// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.subsystems;

import java.lang.invoke.VarHandle;
import java.util.Optional;

import org.photonvision.PhotonCamera;
import org.photonvision.PhotonUtils;
import org.photonvision.targeting.PhotonPipelineResult;
import org.photonvision.targeting.PhotonTrackedTarget;

import edu.wpi.first.apriltag.AprilTagFieldLayout;
import edu.wpi.first.apriltag.AprilTagFields;
import edu.wpi.first.math.geometry.Pose3d;
import edu.wpi.first.math.geometry.Transform2d;
import edu.wpi.first.math.geometry.Transform3d;
import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.SubsystemBase;
import frc.robot.Constants;

public class Vision extends SubsystemBase {


  private PhotonCamera camera;
  private AprilTagFieldLayout aprilTagFieldLayout;

    
  /** Creates a new vision. */
  public Vision() {
    camera = new PhotonCamera(Constants.VisionConstants.MAIN_CAMERA_NAME);

    try {
      aprilTagFieldLayout = AprilTagFieldLayout.loadFromResource(AprilTagFields.k2023ChargedUp.m_resourceFile);
    }
    catch (Exception e) {
      DriverStation.reportError("Vision Subsystem - Error! AprilTagFields.k2023ChargedUp.m_resourceFile not found.", false);
    }
  } 

  
  @Override
  public void periodic() {

    PhotonPipelineResult result = camera.getLatestResult();

    if (result.hasTargets()) {

      PhotonTrackedTarget target = result.getBestTarget();
      
      SmartDashboard.putNumber("Vision : yaw", target.getYaw());
      SmartDashboard.putNumber("Vision : pitch", target.getPitch());
      SmartDashboard.putNumber("Vision : Target ID", target.getFiducialId());

      Transform3d camtotarget = target.getBestCameraToTarget();

      
      
    }
    // This method will be called once per scheduler run
  }

  public PhotonPipelineResult getresult(){
    camera.setPipelineIndex(Constants.VisionConstants.VISION_PIPELINE_INDX_CONES);

    PhotonPipelineResult result = camera.getLatestResult();

    return result;
  }

  public Transform3d getGamePiecePos() {
    Transform3d pose = null;
    
    camera.setPipelineIndex(Constants.VisionConstants.VISION_PIPELINE_INDX_CONES);
    
    PhotonPipelineResult result = camera.getLatestResult();
    
      if (result != null) {
        PhotonTrackedTarget target = result.getBestTarget();
        if (target != null) {
          SmartDashboard.putNumber("getGamePiecePos getX", target.getYaw());
          SmartDashboard.putNumber("getGamePiecePos getX", target.getPitch());
          pose = target.getBestCameraToTarget();
          if (pose !=null){
            SmartDashboard.putNumber("getGamePiecePos getX", pose.getX());
            SmartDashboard.putNumber("getGamePiecePos getX", pose.getY());
            SmartDashboard.putNumber("getGamePiecePos getX", pose.getZ());
          }
        }
      }
      
    return pose;
  }

  public void getApriltagPos() {
    camera.setPipelineIndex(Constants.VisionConstants.VISION_PIPELINE_INDX_APRILTAGS);
    
    PhotonPipelineResult result = camera.getLatestResult();
    if (result.hasTargets()) {
      PhotonTrackedTarget target = result.getBestTarget();
      Transform3d pose = target.getBestCameraToTarget();
      
      SmartDashboard.putNumber("getApriltagPos getFiducialId", target.getFiducialId());
      SmartDashboard.putNumber("getApriltagPos getX", target.getYaw());
      SmartDashboard.putNumber("getApriltagPos getX", target.getPitch());

      SmartDashboard.putNumber("getApriltagPos getX", pose.getX());
      SmartDashboard.putNumber("getApriltagPos getX", pose.getY());
      SmartDashboard.putNumber("getApriltagPos getX", pose.getZ());
    }
  }

  public void testFieldRelativePose() {

    camera.setPipelineIndex(Constants.VisionConstants.VISION_PIPELINE_INDX_APRILTAGS);
    
    PhotonPipelineResult result = camera.getLatestResult();
    if (result.hasTargets()) {
      PhotonTrackedTarget target = result.getBestTarget();

      Optional<Pose3d> tagPose3dOpt = aprilTagFieldLayout.getTagPose(target.getFiducialId());
      Pose3d tagPose3d = tagPose3dOpt.orElse(null);

      Pose3d robotPose = PhotonUtils.estimateFieldToRobotAprilTag(target.getBestCameraToTarget(), 
                                                                  tagPose3d,
                                                                  Constants.VisionConstants.CAMERA_TO_ROBOT);
    }


  }



  public double getTargetPitch() {
    PhotonPipelineResult result = camera.getLatestResult();
  PhotonTrackedTarget target = result.getBestTarget();
    double pitch = target.getPitch();
    return pitch;
  }


public double getTargetyaw() {
  PhotonPipelineResult result = camera.getLatestResult();
  PhotonTrackedTarget target = result.getBestTarget();
  double getYaw = target.getYaw();
  return getYaw;
}



  public boolean hasTargets() {
    PhotonPipelineResult result = camera.getLatestResult();
  PhotonTrackedTarget target = result.getBestTarget();
    boolean hasTargets = result.hasTargets();
    return hasTargets;

 

}
}
