// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.subsystems;

import frc.robot.Constants;

public class OperatorInterface {

  private double DEADZONESIZE = 0.1;

  public double getx() {

      double theXValue = Constants.OiConstants.driverJoyStick.getX();
      //
      if (theXValue == 0) {
        theXValue = Constants.OiConstants.driverController.getRightX();

        theXValue = (theXValue * .5);


      }

      return theXValue;
  }

  public double gety() {

    double theYValue = Constants.OiConstants.driverJoyStick.getY();
    if (theYValue == 0) {
      theYValue = Constants.OiConstants.driverController.getLeftY();

      theYValue = -(theYValue);

    }

      return theYValue;
  }

  public double getThrottle(){
    
      return Constants.OiConstants.driverJoyStick.getThrottle();
  }

  public double limX(){
      double x = getx();
      if(x > DEADZONESIZE){
        x -= DEADZONESIZE;}
      else if(x < -DEADZONESIZE) {
        x += DEADZONESIZE;}
      else {x = 0;}
      
      return x;
  }

  public double limY(){
      double y = gety() * -1;
      if(y > DEADZONESIZE){
        y -= DEADZONESIZE;}
      else if(y < -DEADZONESIZE) {
        y += DEADZONESIZE;}
      else {y = 0;}
      
      return y;
  }


  public double getopy(){
    return Constants.OiConstants.operatorJoyStick.getY();
  }
  public double limopy(){
    double y = getopy() * -1;
    if(y > DEADZONESIZE){
      y -= DEADZONESIZE;}
    else if(y < -DEADZONESIZE) {
      y += DEADZONESIZE;}
    else {y = 0;}
    
    return y;
  }







  
}
