// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.subsystems;

import com.ctre.phoenix.motorcontrol.ControlMode;
import com.ctre.phoenix.motorcontrol.NeutralMode;
import com.ctre.phoenix.motorcontrol.can.WPI_TalonFX;
import com.ctre.phoenix.motorcontrol.can.WPI_TalonSRX;

import edu.wpi.first.wpilibj.Compressor;
import edu.wpi.first.wpilibj.DoubleSolenoid;
import edu.wpi.first.wpilibj.PneumaticsModuleType;
import edu.wpi.first.wpilibj.DoubleSolenoid.Value;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.SubsystemBase;
import frc.robot.Constants;

public class IntakeSubsystem extends SubsystemBase {

  public static final int CUBE_INTAKE_POSITION = 0;
  public static final int CONE_INTAKE_POSITION = 1000;
  public static final int INTAKE_DIRECTION_FORWARD    = 1;
  public static final int INTAKE_DIRECTION_REVERSE    = 2;

  private DoubleSolenoid intakeSolenoid;
  private Compressor phCompressor;

  private static WPI_TalonSRX intakePosMotor;
  private static WPI_TalonSRX rollerPosMotor;
  private static int currentIntakePosition = 0;

  public IntakeSubsystem() {

    phCompressor = new Compressor(Constants.CANConstants.SOLENOID_PCM_ID, PneumaticsModuleType.REVPH);
    phCompressor.enableDigital();
    
    intakeSolenoid = new DoubleSolenoid(Constants.CANConstants.SOLENOID_PCM_ID, 
                                        PneumaticsModuleType.REVPH, 
                                        Constants.ArmConstants.SOLENOID_FWD_CHAN_ID, 
                                        Constants.ArmConstants.SOLENOID_REV_CHAN_ID);
    intakeSolenoid.set(Value.kOff);

    intakePosMotor = new WPI_TalonSRX(Constants.CANConstants.INTAKE_POS_MOTOR);
    intakePosMotor.setNeutralMode(NeutralMode.Brake);

    intakePosMotor.config_kP(0, 0.5);
    intakePosMotor.config_kI(0, 0.0);
    intakePosMotor.config_kD(0, 10);
    intakePosMotor.config_kF(0, 0);
    //intakePosMotor.configMotionSCurveStrength(2);


    rollerPosMotor = new WPI_TalonSRX(Constants.CANConstants.STAGE_4_MOTOR_ID);
    rollerPosMotor.setNeutralMode(NeutralMode.Brake);

    intakePosMotor.set(ControlMode.MotionMagic, 0);

    //engageIntake(INTAKE_DIRECTION_REVERSE);
  }

  @Override
  public void periodic() {
    // This method will be called once per scheduler run
  }

  public void engageIntake(int direction) {
    if(direction == INTAKE_DIRECTION_FORWARD){
      rollerPosMotor.set(ControlMode.PercentOutput, -.75);
    } else if(direction == INTAKE_DIRECTION_REVERSE) {
      rollerPosMotor.set(ControlMode.PercentOutput, .60);
    } else {
      rollerPosMotor.set(ControlMode.PercentOutput, 0.0);
    }
  }

  public void moveIntakeToPosition(int position) {
    intakePosMotor.set(ControlMode.MotionMagic, position);
    currentIntakePosition = position;
  }

  public int getCurrentIntakePosition() {
    return currentIntakePosition;
  }
  
  public void openIntake() {
    intakeSolenoid.set(Value.kForward);
  }
  public void shutIntake() {
    intakeSolenoid.set(Value.kReverse);
  }

  public void allStop() {
    intakeSolenoid.set(Value.kOff);
    //phCompressor.disable();
    this.engageIntake(0);
  }

  public static void resetEncoders() {
    intakePosMotor.setSelectedSensorPosition(0);
    
  }
}
