// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.subsystems;

import com.ctre.phoenix.sensors.WPI_Pigeon2;

import edu.wpi.first.math.geometry.Rotation2d;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;


import edu.wpi.first.wpilibj2.command.SubsystemBase;
import frc.robot.Constants;

public class Gyro extends SubsystemBase {
  /** Creates a new gyro. */
private WPI_Pigeon2 gyro;

  public Gyro() {
    gyro = new WPI_Pigeon2(Constants.CANConstants.GYRO_ID);
  }

  @Override
  public void periodic() {
    // This method will be called once per scheduler run
    
    SmartDashboard.putNumber("Gyro : yaw", gyro.getYaw());
    SmartDashboard.putNumber("Gyro : pitch", gyro.getPitch());
    SmartDashboard.putNumber("Gyro : roll", gyro.getRoll());
  }

  public double getPitch() {
    return (-this.gyro.getPitch());
  }
  
  public Rotation2d getRotation() {
    return this.gyro.getRotation2d();
  }

}
