// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.subsystems;

import org.photonvision.PhotonUtils;
import org.photonvision.targeting.PhotonPipelineResult;

import com.ctre.phoenix.motorcontrol.ControlMode;
import com.ctre.phoenix.motorcontrol.NeutralMode;
import com.ctre.phoenix.motorcontrol.can.WPI_TalonFX;

import edu.wpi.first.math.controller.PIDController;
import edu.wpi.first.math.geometry.Transform3d;
import edu.wpi.first.math.util.Units;
import edu.wpi.first.wpilibj.drive.DifferentialDrive;
import edu.wpi.first.wpilibj.motorcontrol.MotorControllerGroup;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.SubsystemBase;
import frc.robot.Constants;
import frc.robot.RobotContainer;

public class Drivetrain extends SubsystemBase {

  public static final int NEUTRALMODE_COAST = 1001;
  public static final int NEUTRALMODE_BRAKE = 1002;

  public static final String MOTOR_ID_FR = "FR";
  public static final String MOTOR_ID_FL = "FL";
  public static final String MOTOR_ID_RR = "RR";
  public static final String MOTOR_ID_RL = "RL";

  private WPI_TalonFX FR;
  private WPI_TalonFX FL;
  private WPI_TalonFX RR;
  private WPI_TalonFX RL;

  final double P_GAIN = 0.1;
  final double D_GAIN = 0.0;
  PIDController controller = new PIDController(P_GAIN, 0, D_GAIN);

  final double ANGULAR_P = 0.1;
  final double ANGULAR_D = 0.0;
  PIDController turnController = new PIDController(ANGULAR_P, 0, ANGULAR_D);

  private boolean previousTV = true;
  private long timeLastSawTargetInYRange = -1;
  private static final long lostTargetWaitTimeMS = 3000l;


  //private MotorControllerGroup rightMotorControllerGroup;
  //private MotorControllerGroup leftMotorControllerGroup;
  //private DifferentialDrive differentialDrive;



  /** Creates a new Drivetrain. */
  public Drivetrain() {

    FR = new WPI_TalonFX(Constants.CANConstants.DRIVE_FR_ID);
    FL = new WPI_TalonFX(Constants.CANConstants.DRIVE_FL_ID);
    RR = new WPI_TalonFX(Constants.CANConstants.DRIVE_RR_ID);
    RL = new WPI_TalonFX(Constants.CANConstants.DRIVE_RL_ID);

    FR.configOpenloopRamp(0.5);
    FL.configOpenloopRamp(0.5);
    RR.configOpenloopRamp(0.5);
    RL.configOpenloopRamp(0.5);

    FR.setNeutralMode(NeutralMode.Brake);
    FL.setNeutralMode(NeutralMode.Brake);
    RR.setNeutralMode(NeutralMode.Brake);
    RL.setNeutralMode(NeutralMode.Brake); 
    
    //rightMotorControllerGroup = new MotorControllerGroup(FR, RR);
    //leftMotorControllerGroup = new MotorControllerGroup(RL, FL);

    //differentialDrive = new DifferentialDrive(rightMotorControllerGroup, leftMotorControllerGroup);

    SmartDashboard.getNumber("Apriltag Track forwardSpeed=", -1);
    SmartDashboard.getNumber("Apriltag Track rotationSpeed=", -1);

  }
  /*public void invertLeftDrive() {
    leftMotorControllerGroup.setInverted(true);
  }*/

  public void calcArcadeDrive() {
    double V;
    double W;
    double ABSX;
    double ABSY;

    double X = ABSX = RobotContainer.OperatorInterface.limX() * 100;
    double Y = ABSY = RobotContainer.OperatorInterface.limY() * 100 * -1;
    double Throttle = ((RobotContainer.OperatorInterface.getThrottle() * -1) + 1) / 2;

    SmartDashboard.putNumber("Drive throttle", Throttle);
    if (ABSX < 0) {
      ABSX = -ABSX;
    }

    if (ABSY < 0) {
      ABSY = -ABSY;
    }

    V = (100 - ABSX) * (Y / 100) + Y;
    W = (100 - ABSY) * (X / 100) + X;

    double r = (((V - W) / 2) / 100) * Throttle;
    double l = (((V + W) / 2) / 100) * Throttle;

    FR.set(ControlMode.PercentOutput, r * -1);
    RR.set(ControlMode.PercentOutput, r * -1);
    FL.set(ControlMode.PercentOutput, l);
    RL.set(ControlMode.PercentOutput, l);
  }
  
  /*public void calcDiffArcadeDrive(double speed, double rotationSpeed){
    
    differentialDrive.arcadeDrive(speed,rotationSpeed);
    
  }

  /**
   * Drive the robot using Percent control
   * 
   * @param L - How fast to run the left side of the drivetrain
   * @param R - How fast to run the right side of the drivetrain
   */
  
  
   public void Move(double L, double R) {
    
    
    FL.set(ControlMode.PercentOutput, -L);
    RL.set(ControlMode.PercentOutput, -L);

    FR.set(ControlMode.PercentOutput, R);
    RR.set(ControlMode.PercentOutput, R);
  }

  public double getMotorPosition(String motor) {

    double position = 0;

    switch (motor) {
      case "FR":
        position = FR.getSelectedSensorPosition();
        break;

      case "RR":
        position = RR.getSelectedSensorPosition();
        break;
      case "RL":
        position = RL.getSelectedSensorPosition();
        break;
      case "Fl":
        position = FL.getSelectedSensorPosition();
        break;
    }

    SmartDashboard.getNumber("rear left motor",RL.getSelectedSensorPosition() );

    return position;
  }

  public void setDriveMotorMode(int drivetrainNeutralMode) {

    if (drivetrainNeutralMode == Drivetrain.NEUTRALMODE_BRAKE) {
      FR.setNeutralMode(NeutralMode.Brake);
      FL.setNeutralMode(NeutralMode.Brake);
      RR.setNeutralMode(NeutralMode.Brake);
      RL.setNeutralMode(NeutralMode.Brake);   
    }
    else if (drivetrainNeutralMode == Drivetrain.NEUTRALMODE_COAST) {
      FR.setNeutralMode(NeutralMode.Coast);
      FL.setNeutralMode(NeutralMode.Coast);
      RR.setNeutralMode(NeutralMode.Coast);
      RL.setNeutralMode(NeutralMode.Coast);   
    } 
  }


  public void aprilTagTrack(){
    double forwardSpeed = 0;
    double rotationSpeed = 0;

    
        // Vision-alignment mode
        // Query the latest result from PhotonVision
        

        if (RobotContainer.visionSubSystem.hasTargets()) {
            // First calculate range
            double range =
                    PhotonUtils.calculateDistanceToTargetMeters(
                            Constants.DrivetrainConstants.FRONT_CAMERA_HEIGHT_METERS,
                            Constants.DrivetrainConstants.APRILTAG_HEIGHT_METERS,
                            Constants.DrivetrainConstants.FRONT_CAMERA_PITCH_RADIANS,
                            Units.degreesToRadians(RobotContainer.visionSubSystem.getTargetPitch()));

            // Use this range as the measurement we give to the PID controller.
            // -1.0 required to ensure positive PID controller effort _increases_ range
            forwardSpeed = -controller.calculate(range, Constants.DrivetrainConstants.GOAL_RANGE_METERS)/4;
            rotationSpeed = -turnController.calculate(RobotContainer.visionSubSystem.getTargetyaw())/4;


          SmartDashboard.getNumber("Apriltag Track forwardSpeed=", forwardSpeed);
          SmartDashboard.getNumber("Apriltag Track rotationSpeed=", rotationSpeed);

          //calcDiffArcadeDrive(forwardSpeed, rotationSpeed);
        } else {
          calcArcadeDrive();
    }
   

    // Use our forward/turn speeds to control the drivetrain
    
}

public void GamePiecetrack(){
  double throttleCap = 0.5;
  Transform3d pose = RobotContainer.visionSubSystem.getGamePiecePos();
  if (pose != null) {
    
      PhotonPipelineResult result = RobotContainer.visionSubSystem.getresult();
      double tx = pose.getX();
      double ty = pose.getY() ;
      boolean tv = result != null && result.hasTargets();

      double offsetX = (tx/29.8)/3;
      double offsetY = ((ty/49)/2);

      // had a target and lost it. 
      if ((previousTV && !tv) && ((System.currentTimeMillis() - timeLastSawTargetInYRange) <= lostTargetWaitTimeMS)) {
          // Do not progress forward or backward.
          offsetY = .2;
      }
      else {
          previousTV = tv;
          timeLastSawTargetInYRange = System.currentTimeMillis();
      }
      /*
      SmartDashboard.putNumber("Low Camera x", tx);
      SmartDashboard.putNumber("Low Camera v", tv);
      SmartDashboard.putNumber("BallTrackDrive Left", (offsetY + offsetX));
      SmartDashboard.putNumber("BallTrackDrive Right", (offsetY + -offsetX));
      */
      // Controls all robot movement X & Y
      if (tv) {

          // limit top speed to throttleCap as set above in this method 
          if (offsetY > throttleCap) {
              offsetY = throttleCap;
          }

          Move(offsetY + -offsetX, offsetY + offsetX);
      } else {
        calcArcadeDrive();
      }
  }
}

public void toggleBreakMode(boolean brakeOn) {
  if (brakeOn) {
    FR.setNeutralMode(NeutralMode.Brake);
    RR.setNeutralMode(NeutralMode.Brake);
    FL.setNeutralMode(NeutralMode.Brake);
    RL.setNeutralMode(NeutralMode.Brake);
    
    SmartDashboard.putBoolean("Arm - Drive Brake mode: ", true);
  }
  else {
    FR.setNeutralMode(NeutralMode.Coast);
    RR.setNeutralMode(NeutralMode.Coast);
    FL.setNeutralMode(NeutralMode.Coast);
    RL.setNeutralMode(NeutralMode.Coast);
    
    SmartDashboard.putBoolean("Arm - Drive Brake mode: ", false);
  }
}  

  @Override
  public void periodic() {
    // This method will be called once per scheduler run
  }
}
