// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.subsystems;

import javax.lang.model.util.ElementScanner14;

import com.ctre.phoenix.motorcontrol.ControlMode;
import com.ctre.phoenix.motorcontrol.NeutralMode;
import com.ctre.phoenix.motorcontrol.can.WPI_TalonFX;
import com.ctre.phoenix.motorcontrol.can.WPI_TalonSRX;

import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.SubsystemBase;
import frc.robot.Constants;


public class Arm extends SubsystemBase {

  public static final int ROBOT_ARM_SIDE_FRONT            = 2001;
  public static final int ROBOT_ARM_SIDE_BACK             = 2002;
  public static final int ROBOT_ARM_SIDE_UNKNOWN          = 2003;

  /// Cube Back Floor
  private static final int ARM_STAGE_ONE_BK_CUBE_FLR      = -48282;

  private static final int ARM_STAGE_TWO_BK_CUBE_FLR      = 7546;
  private static final int ARM_STAGE_THREE_BK_CUBE_FLR    = -2087;

  /// Cube Back Mid
  private static final int ARM_STAGE_ONE_BK_CUBE_MID      = -10765;
  private static final int ARM_STAGE_TWO_BK_CUBE_MID      = 24039;
  private static final int ARM_STAGE_THREE_BK_CUBE_MID    = -1812;

  /// Cube Back Low
  private static final int ARM_STAGE_ONE_BK_CUBE_LOW      = 0;
  private static final int ARM_STAGE_TWO_BK_CUBE_LOW      = 0;
  private static final int ARM_STAGE_THREE_BK_CUBE_LOW    = 0;

  /// Cube Back High
  private static final int ARM_STAGE_ONE_BK_CUBE_HIGH     = -54235;
  private static final int ARM_STAGE_TWO_BK_CUBE_HIGH     = 45464;
  private static final int ARM_STAGE_THREE_BK_CUBE_HIGH   = -2500;

  /// Cone Back Floor
  /*private static final int ARM_STAGE_ONE_BK_CONE_FLR      = 300;
  private static final int ARM_STAGE_TWO_BK_CONE_FLR      = 17056;
  private static final int ARM_STAGE_THREE_BK_CONE_FLR    = -10973;*/
  private static final int ARM_STAGE_ONE_BK_CONE_FLR      = -55016;
  private static final int ARM_STAGE_TWO_BK_CONE_FLR      = 5371;
  private static final int ARM_STAGE_THREE_BK_CONE_FLR    = -4872;

  /// Cone Back Mid
  private static final int ARM_STAGE_ONE_BK_CONE_MID      = -19738;
  private static final int ARM_STAGE_TWO_BK_CONE_MID      = 39658;
  private static final int ARM_STAGE_THREE_BK_CONE_MID    = -10038;

  /// Cone Back High 
  private static final int ARM_STAGE_ONE_BK_CONE_HIGH     = -58245;
  private static final int ARM_STAGE_TWO_BK_CONE_HIGH     = 60516;
  private static final int ARM_STAGE_THREE_BK_CONE_HIGH   = -8598;

  ////

  /// Cube Front Floor  // TODO Values in pic same as previous
  private static final int ARM_STAGE_ONE_FR_CUBE_FLR      = -10974;
  private static final int ARM_STAGE_TWO_FR_CUBE_FLR      = 118786;
  private static final int ARM_STAGE_THREE_FR_CUBE_FLR    = 1039;

  /// Cube Front mid   // TODO Values in pic same as previous
  private static final int ARM_STAGE_ONE_FR_CUBE_MID      = -21334;
  private static final int ARM_STAGE_TWO_FR_CUBE_MID      = 99717;
  private static final int ARM_STAGE_THREE_FR_CUBE_MID    = 2798;

  /// Cube Back Low
  private static final int ARM_STAGE_ONE_FR_CUBE_LOW      = 0;
  private static final int ARM_STAGE_TWO_FR_CUBE_LOW      = 0;
  private static final int ARM_STAGE_THREE_FR_CUBE_LOW    = -3700;  // same as On Back

  /// Cube Front High  
  private static final int ARM_STAGE_ONE_FR_CUBE_HIGH     = 15043;
  private static final int ARM_STAGE_TWO_FR_CUBE_HIGH     = 85281;
  private static final int ARM_STAGE_THREE_FR_CUBE_HIGH   = -4673;

  /// Cone Front Floor
  private static final int ARM_STAGE_ONE_FR_CONE_FLR      = 4163;
  private static final int ARM_STAGE_TWO_FR_CONE_FLR      = 1473;
  private static final int ARM_STAGE_THREE_FR_CONE_FLR    = -11849;

  /// Cone Front Mid
  private static final int ARM_STAGE_ONE_FR_CONE_MID      = -32024;
  private static final int ARM_STAGE_TWO_FR_CONE_MID      = 104296;
  private static final int ARM_STAGE_THREE_FR_CONE_MID    = -940;

  /// Cone Front High
  private static final int ARM_STAGE_ONE_FR_CONE_HIGH     = 19002;
  private static final int ARM_STAGE_TWO_FR_CONE_HIGH     = 69000;
  private static final int ARM_STAGE_THREE_FR_CONE_HIGH   = -500;

  /// Termainal Front
  private static final int ARM_STAGE_ONE_FR_TERMINAL   = 0;
  private static final int ARM_STAGE_TWO_FR_TERMINAL   = 0;
  private static final int ARM_STAGE_THREE_FR_TERMINAL   = 0;

  /// Terminal Cube Back
  private static final int ARM_STAGE_ONE_BK_TERMINAL   = 8502;
  private static final int ARM_STAGE_TWO_BK_TERMINAL   = 11146;
  private static final int ARM_STAGE_THREE_BK_TERMINAL   = -1082;

  /// Terminal Cone Back
  private static final int ARM_STAGE_ONE_BK_CONE_TERMINAL   = 41399;
  private static final int ARM_STAGE_TWO_BK_CONE_TERMINAL   = 5545;
  private static final int ARM_STAGE_THREE_BK_CONE_TERMINAL   = -8008;

  /// Shelf Cube Back
  private static final int ARM_STAGE_ONE_BK_CUBE_SHELF      = 13328;
  private static final int ARM_STAGE_TWO_BK_CUBE_SHELF      = 28216;
  private static final int ARM_STAGE_THREE_BK_CUBE_SHELF    = -6470 ;
  
  /// Shelf Cone Back
  private static final int ARM_STAGE_ONE_BK_CONE_SHELF      = -10122;
  private static final int ARM_STAGE_TWO_BK_CONE_SHELF      = 49227;
  private static final int ARM_STAGE_THREE_BK_CONE_SHELF    = -12922 ;


  ////////// Stage One Positions
  /////
  private static final int ARM_STAGE_ONE_FROM_FR_OTT   = 0;
  private static final int ARM_STAGE_ONE_FROM_BK_OTT   = -43071;
  /////
  public static final StagePositionData ARM_STAGE_ONE_CUBE_HIGH = new StagePositionData(ARM_STAGE_ONE_FR_CUBE_HIGH, ARM_STAGE_ONE_BK_CUBE_HIGH);
  public static final StagePositionData ARM_STAGE_ONE_CUBE_MID = new StagePositionData(ARM_STAGE_ONE_FR_CUBE_MID, ARM_STAGE_ONE_BK_CUBE_MID);
  public static final StagePositionData ARM_STAGE_ONE_CUBE_LOW = new StagePositionData(ARM_STAGE_ONE_FR_CUBE_LOW, ARM_STAGE_ONE_BK_CUBE_LOW);
  public static final StagePositionData ARM_STAGE_ONE_CUBE_FLOOR = new StagePositionData(ARM_STAGE_ONE_FR_CUBE_FLR, ARM_STAGE_ONE_BK_CUBE_FLR);
  /////
  public static final StagePositionData ARM_STAGE_ONE_CONE_HIGH = new StagePositionData(ARM_STAGE_ONE_FR_CONE_HIGH, ARM_STAGE_ONE_BK_CONE_HIGH);
  public static final StagePositionData ARM_STAGE_ONE_CONE_MID = new StagePositionData(ARM_STAGE_ONE_FR_CONE_MID, ARM_STAGE_ONE_BK_CONE_MID);
  public static final StagePositionData ARM_STAGE_ONE_CONE_FLOOR = new StagePositionData(ARM_STAGE_ONE_FR_CONE_FLR, ARM_STAGE_ONE_BK_CONE_FLR);
  /////
  public static final StagePositionData ARM_STAGE_ONE_TERMINAL = new StagePositionData(ARM_STAGE_ONE_FR_TERMINAL, ARM_STAGE_ONE_BK_TERMINAL);
  // TODO Get front position
  public static final StagePositionData ARM_STAGE_ONE_CONE_TERMINAL = new StagePositionData(ARM_STAGE_ONE_BK_CONE_TERMINAL, ARM_STAGE_ONE_BK_CONE_TERMINAL);

  ///// Shelf
  public static final StagePositionData ARM_STAGE_ONE_CUBE_SHELF = new StagePositionData(ARM_STAGE_ONE_BK_CUBE_SHELF, ARM_STAGE_ONE_BK_CUBE_SHELF);
  public static final StagePositionData ARM_STAGE_ONE_CONE_SHELF = new StagePositionData(ARM_STAGE_ONE_BK_CONE_SHELF, ARM_STAGE_ONE_BK_CONE_SHELF);


  /////
  public static final StagePositionData ARM_STAGE_ONE_OTT = new StagePositionData(ARM_STAGE_ONE_FROM_FR_OTT, ARM_STAGE_ONE_FROM_BK_OTT);


  ////////// Stage Two Positions
  private static final int ARM_STAGE_TWO_FROM_FR_OTT   = 0;
  private static final int ARM_STAGE_TWO_FROM_BK_OTT   = 128883;
  /////
  public static final StagePositionData ARM_STAGE_TWO_CUBE_HIGH = new StagePositionData(ARM_STAGE_TWO_FR_CUBE_HIGH, ARM_STAGE_TWO_BK_CUBE_HIGH);
  public static final StagePositionData ARM_STAGE_TWO_CUBE_MID = new StagePositionData(ARM_STAGE_TWO_FR_CUBE_MID, ARM_STAGE_TWO_BK_CUBE_MID);
  public static final StagePositionData ARM_STAGE_TWO_CUBE_LOW = new StagePositionData(ARM_STAGE_TWO_FR_CUBE_LOW, ARM_STAGE_TWO_BK_CUBE_LOW);
  public static final StagePositionData ARM_STAGE_TWO_CUBE_FLOOR = new StagePositionData(ARM_STAGE_TWO_FR_CUBE_FLR, ARM_STAGE_TWO_BK_CUBE_FLR);
  /////
  public static final StagePositionData ARM_STAGE_TWO_CONE_HIGH = new StagePositionData(ARM_STAGE_TWO_FR_CONE_HIGH, ARM_STAGE_TWO_BK_CONE_HIGH);
  public static final StagePositionData ARM_STAGE_TWO_CONE_MID = new StagePositionData(ARM_STAGE_TWO_FR_CONE_MID, ARM_STAGE_TWO_BK_CONE_MID);
  public static final StagePositionData ARM_STAGE_TWO_CONE_FLOOR = new StagePositionData(ARM_STAGE_TWO_FR_CONE_FLR, ARM_STAGE_TWO_BK_CONE_FLR);
  /////
  public static final StagePositionData ARM_STAGE_TWO_TERMINAL = new StagePositionData(ARM_STAGE_TWO_FR_TERMINAL, ARM_STAGE_TWO_BK_TERMINAL);
  public static final StagePositionData ARM_STAGE_TWO_CONE_TERMINAL = new StagePositionData(ARM_STAGE_TWO_BK_CONE_TERMINAL, ARM_STAGE_TWO_BK_CONE_TERMINAL);
  /////

  public static final StagePositionData ARM_STAGE_TWO_CUBE_SHELF = new StagePositionData(ARM_STAGE_TWO_BK_CUBE_SHELF, ARM_STAGE_TWO_BK_CUBE_SHELF);
  public static final StagePositionData ARM_STAGE_TWO_CONE_SHELF = new StagePositionData(ARM_STAGE_TWO_BK_CONE_SHELF, ARM_STAGE_TWO_BK_CONE_SHELF);

  /////
  public static final StagePositionData ARM_STAGE_TWO_OTT = new StagePositionData(ARM_STAGE_TWO_FROM_FR_OTT, ARM_STAGE_TWO_FROM_BK_OTT);

  // used to detect which side of the robot the arm is on.
  public static final int ARM_STAGE_TWO_ON_FRONT      = 62469;
  public static final int ARM_STAGE_TWO_ON_BACK       = 62468; 


  ////////// Stage Three Positions
  private static final int ARM_STAGE_THREE_FROM_FR_OTT   = 0;
  private static final int ARM_STAGE_THREE_FROM_BK_OTT   = -8870;
  /////
  public static final StagePositionData ARM_STAGE_THREE_CUBE_HIGH = new StagePositionData(ARM_STAGE_THREE_FR_CUBE_HIGH, ARM_STAGE_THREE_BK_CUBE_HIGH);
  public static final StagePositionData ARM_STAGE_THREE_CUBE_MID = new StagePositionData(ARM_STAGE_THREE_FR_CUBE_MID, ARM_STAGE_THREE_BK_CUBE_MID);
  public static final StagePositionData ARM_STAGE_THREE_CUBE_LOW = new StagePositionData(ARM_STAGE_THREE_FR_CUBE_LOW, ARM_STAGE_THREE_BK_CUBE_LOW);
  public static final StagePositionData ARM_STAGE_THREE_CUBE_FLOOR = new StagePositionData(ARM_STAGE_THREE_FR_CUBE_FLR, ARM_STAGE_THREE_BK_CUBE_FLR);
  /////
  public static final StagePositionData ARM_STAGE_THREE_CONE_HIGH = new StagePositionData(ARM_STAGE_THREE_FR_CONE_HIGH, ARM_STAGE_THREE_BK_CONE_HIGH);
  public static final StagePositionData ARM_STAGE_THREE_CONE_MID = new StagePositionData(ARM_STAGE_THREE_FR_CONE_MID, ARM_STAGE_THREE_BK_CONE_MID);
  public static final StagePositionData ARM_STAGE_THREE_CONE_FLOOR = new StagePositionData(ARM_STAGE_THREE_FR_CONE_FLR, ARM_STAGE_THREE_BK_CONE_FLR);
  /////
  public static final StagePositionData ARM_STAGE_THREE_TERMINAL = new StagePositionData(ARM_STAGE_THREE_FR_TERMINAL, ARM_STAGE_THREE_BK_TERMINAL);
  public static final StagePositionData ARM_STAGE_THREE_CONE_TERMINAL = new StagePositionData(ARM_STAGE_THREE_BK_CONE_TERMINAL, ARM_STAGE_THREE_BK_CONE_TERMINAL);

  /////
  public static final StagePositionData ARM_STAGE_THREE_CUBE_SHELF = new StagePositionData(ARM_STAGE_THREE_BK_CUBE_SHELF, ARM_STAGE_THREE_BK_CUBE_SHELF);
  public static final StagePositionData ARM_STAGE_THREE_CONE_SHELF = new StagePositionData(ARM_STAGE_THREE_BK_CONE_SHELF, ARM_STAGE_THREE_BK_CONE_SHELF);

  /////
  public static final StagePositionData ARM_STAGE_THREE_OTT = new StagePositionData(ARM_STAGE_THREE_FROM_FR_OTT, ARM_STAGE_THREE_FROM_BK_OTT);
  

  // "Zero" position
  public static final StagePositionData ARM_STAGE_ONE_ZERO = new StagePositionData(ARM_STAGE_ONE_FROM_FR_OTT, 0);
  public static final StagePositionData ARM_STAGE_TWO_ZERO = new StagePositionData(ARM_STAGE_TWO_FROM_FR_OTT, 0);
  public static final StagePositionData ARM_STAGE_THREE_ZERO = new StagePositionData(ARM_STAGE_THREE_FROM_BK_OTT, 0);

  private static WPI_TalonFX stageOne;   // bottom Arm
  public static WPI_TalonFX stageTwo;   // top arm 
  private static WPI_TalonSRX stageThree; // wrist
  boolean NeutralModestateIsBrake = true;

  // TODO - Is this unused? 
  public static double STAGE_TWO_CURRENT_POS = 0;

  public Arm() {
    
    SmartDashboard.putBoolean("Arm - Brake mode: ", true);
    
    stageOne = new WPI_TalonFX(Constants.CANConstants.STAGE_1_MOTOR_ID);
    stageTwo = new WPI_TalonFX(Constants.CANConstants.STAGE_2_MOTOR_ID);
    stageThree = new WPI_TalonSRX(Constants.CANConstants.STAGE_3_MOTOR_ID);
    stageOne.setNeutralMode(NeutralMode.Brake);
    stageTwo.setNeutralMode(NeutralMode.Brake);
    stageThree.setNeutralMode(NeutralMode.Brake);

    stageOne.config_kP(0, 0.4);  // getting there
    stageOne.config_kI(0, 0.0);   // D can't quiet get it so adust I to fine tune.
    stageOne.config_kD(0, 
    0);    // overshoot (how much does it come back)
    stageOne.config_kF(0, 0.0);     // Feed forward - counter act gravity.
    stageOne.configMotionSCurveStrength(3);
    stageOne.configMotionAcceleration(6000, 30);

    stageTwo.config_kP(0, 0.4);
    stageTwo.config_kI(0, 0.0);
    stageTwo.config_kD(0, 0);
    stageTwo.config_kF(0, 0);
    stageTwo.configMotionSCurveStrength(3);
    stageTwo.configMotionAcceleration(6000, 30);

    
    stageThree.config_kP(0, 0.8);
    stageThree.config_kI(0, 0.0008);
    stageThree.config_kD(0, 0); //10
    stageThree.config_kF(0, 0);
    stageThree.configMotionSCurveStrength(3);
    stageThree.configMotionAcceleration(3000, 30);

    //stageThree.setSensorPhase(true);

    //intakeSolenoid = new DoubleSolenoid(9, PneumaticsModuleType.REVPH, Constants.ArmConstants.SOLENOID_FWD_CHAN_ID, Constants.ArmConstants.SOLENOID_REV_CHAN_ID);
    //intakeSolenoid.set(Value.kOff);

    
  }

  @Override
  public void periodic() {
    // This method will be called once per scheduler run
    
    SmartDashboard.putNumber("Arm - stageOne pos: ", stageOne.getSelectedSensorPosition());
    SmartDashboard.putNumber("Arm - stageTwo pos: ", stageTwo.getSelectedSensorPosition());
    STAGE_TWO_CURRENT_POS = stageTwo.getSelectedSensorPosition();
    SmartDashboard.putNumber("Arm - stageThree pos: ", stageThree.getSelectedSensorPosition());


    


  }

  public void resetEncoders() {
    stageOne.setSelectedSensorPosition(0);
    stageTwo.setSelectedSensorPosition(0);
    stageThree.setSelectedSensorPosition(0);
  }

  public void resetStageThreeEncoder(){
    stageThree.setSelectedSensorPosition(0);
  }

  // move the different arms and report their position
  public void moveStageOneToPos(int position) {
    SmartDashboard.putNumber("Arm - moveStageOneToPos pos: ", position);

    stageOne.configMotionAcceleration(Constants.ArmConstants.CRUISE_VELOCITY_ACCEL_UP, 0);
    stageOne.configMotionCruiseVelocity(Constants.ArmConstants.CRUISE_VELOCITY_ACCEL_UP, 0);
    stageOne.set(ControlMode.MotionMagic, position);

    //stageOne.set(ControlMode.Position, pos);
  }
  public double getStageOnePos() {
    return stageOne.getSelectedSensorPosition();
  }

  public void moveStageTwoToPos(int position) {
    stageTwo.configMotionAcceleration(Constants.ArmConstants.CRUISE_VELOCITY_ACCEL_UP, 0);
    stageTwo.configMotionCruiseVelocity(Constants.ArmConstants.CRUISE_VELOCITY_ACCEL_UP, 0);
    stageTwo.set(ControlMode.MotionMagic, position);


    //stageTwo.set(ControlMode.Position, pos);
  }
  public double getStageTwoPos() {
    return stageTwo.getSelectedSensorPosition();
  }

  public void moveStageThreeToPos(int pos) {
    stageThree.set(ControlMode.MotionMagic, pos);
  }
  public double getStageThreePos() {
    return stageThree.getSelectedSensorPosition();
  }

  public void moveStageThreeManual(double speed){

    stageThree.set(ControlMode.PercentOutput,speed);
  }
/**
 * 0 = off
 * 1 = forward
 * 2 = reverse
 * 
 * @param reverse
 */

  // Judge which side of the robot the arm is on
  public static int getWhichSideIsArm() {

    int sideToReturn = ROBOT_ARM_SIDE_UNKNOWN;

    if (stageTwo.getSelectedSensorPosition() >= Arm.ARM_STAGE_TWO_ON_FRONT) {
      sideToReturn = ROBOT_ARM_SIDE_FRONT;
    }
    else if (stageTwo.getSelectedSensorPosition() <= Arm.ARM_STAGE_TWO_ON_BACK) {
      sideToReturn = ROBOT_ARM_SIDE_BACK;
    }

    return sideToReturn;
  }

  public void allStop() {
    stageOne.set(ControlMode.PercentOutput, 0);
    stageTwo.set(ControlMode.PercentOutput, 0);
    stageThree.set(ControlMode.PercentOutput, 0);
  }
  
  public void toggleBreakMode(boolean brakeOn) {
    if (brakeOn) {
      stageOne.setNeutralMode(NeutralMode.Brake);
      stageTwo.setNeutralMode(NeutralMode.Brake);
      stageThree.setNeutralMode(NeutralMode.Brake);
    }
    else {
      stageOne.setNeutralMode(NeutralMode.Coast);
      stageTwo.setNeutralMode(NeutralMode.Coast);
      stageThree.setNeutralMode(NeutralMode.Coast);
    }
  }

  //////////////////////////////////////////////////////////
  public void calibrateStageOne(boolean reverse) {
    double outputPerc = 0.25;
    if (reverse) {
      outputPerc = -outputPerc;
    }

    stageOne.set(ControlMode.PercentOutput, outputPerc);
  }

  public void calibrateStageTwo(boolean reverse) {
    double outputPerc = 0.25;
    if (reverse) {
      outputPerc = -outputPerc;
    }

    stageTwo.set(ControlMode.PercentOutput, outputPerc);
  }
}
