// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands;

import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj2.command.CommandBase;
import frc.robot.RobotContainer;

public class ledCommand extends CommandBase {

  public static final int YELLOW_FLASH = 1;
  public static final int YELLOW_SOLID = 2;
  public static final int PURPLE_FLASH = 3;
  public static final int PURPLE_SOLID = 4;
  
  private int specifiedLedMode;
  
  /** Creates a new ledCommand. */
  public ledCommand(int specifiedLedMode) {
    // Use addRequirements() here to declare subsystem dependencies.
    this.specifiedLedMode = specifiedLedMode;
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {
  }

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {
    double ledId = RobotContainer.LedSubsystem.YELLOW_FLASH;
    switch (specifiedLedMode){
      //int id = 1;
      case YELLOW_FLASH:
        ledId = RobotContainer.LedSubsystem.YELLOW_FLASH;
        //id ++;
        break;
      
      case YELLOW_SOLID:
        ledId = RobotContainer.LedSubsystem.YELLOW_SOLID;
        //id ++;
        break;

      case PURPLE_FLASH:
        ledId = RobotContainer.LedSubsystem.PURPLE_FLASH;
        //id ++;
        break;

      case PURPLE_SOLID:
        ledId = RobotContainer.LedSubsystem.PURPLE_SOLID;
        //id = 1;
        break;
    }
    RobotContainer.LedSubsystem.ledMode(ledId);
  }

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {

    // solid blue = 0.87
    // solid red  = 0.61
    if (DriverStation.getAlliance() == DriverStation.Alliance.Blue) {
      RobotContainer.LedSubsystem.ledMode(0.87);
      
    } else{
      if (DriverStation.getAlliance() == DriverStation.Alliance.Red) {
          RobotContainer.LedSubsystem.ledMode(0.61);
      }
    }
  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {
    return false;
  }
}
