// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands.armcommands.armsubcommands;

import edu.wpi.first.wpilibj2.command.CommandBase;
import frc.robot.RobotContainer;
import frc.robot.subsystems.Arm;
import frc.robot.subsystems.StagePositionData;

public class ArmStageThreeCommand extends CommandBase {

  private StagePositionData targetPosition;
  private int targetPosValue = -1;

  /** Creates a new VisionTestCommand. */
  public ArmStageThreeCommand(StagePositionData targetPosition) {
    // Use addRequirements() here to declare subsystem dependencies.
    //addRequirements(RobotContainer.armSubSystem);
    this.targetPosition = targetPosition;
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {
    //this.targetPosValue = targetPosition.getPosition(Arm.ROBOT_ARM_SIDE_BACK);
    this.targetPosValue = targetPosition.getPosition(ArmPositionStateCommand.ARM_POSITION_AT_FUNCTION_START);
  }

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {

    RobotContainer.armSubSystem.moveStageThreeToPos(targetPosValue);
    //RobotContainer.armSubSystem.moveStageThreeToPos(targetPosition.getPosition(ArmPositionStateCommand.ARM_POSITION_AT_FUNCTION_START));
  }
    

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {
    System.out.println("-------------------------------- ArmStageThreeCommand ENDING");
  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {

    double actualPosition = Math.abs(RobotContainer.armSubSystem.getStageThreePos());
    double absTargetPosition = Math.abs(targetPosValue);

    // TODO do something more eloquent for margin of error in encoder.
    boolean isWithinTargetRange = actualPosition > (absTargetPosition - 500) && 
                                  actualPosition < (absTargetPosition + 500);

    return isWithinTargetRange;
  }
}
