// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands.armcommands.armsubcommands;

import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.CommandBase;
import frc.robot.RobotContainer;
import frc.robot.subsystems.Arm;

public class ArmPositionStateCommand extends CommandBase {

  public static int ARM_POSITION_AT_FUNCTION_START = Arm.ROBOT_ARM_SIDE_UNKNOWN;

  public static final int ARM_POSITION_STATE_BEGIN = 4001;
  public static final int ARM_POSITION_STATE_END   = 4002;

  private int armPositionState;
  public static final int CUBE = 4001;
  public static final int CONE = 4002;
  public int classLvlCubeOrCone = CUBE;
  public static int cubeOrCone = CUBE;

  /** Creates a new VisionTestCommand. */
  public ArmPositionStateCommand(int armPositionState, int classLvlCubeOrCone) {
    // Use addRequirements() here to declare subsystem dependencies.
    //addRequirements(RobotContainer.armSubSystem);
    this.armPositionState = armPositionState;
    this.classLvlCubeOrCone = classLvlCubeOrCone;
    cubeOrCone = classLvlCubeOrCone;
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {
  }

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {

    System.out.println("-------------------------------- ArmPositionStateCommand Execute   armPositionState="+armPositionState);

    cubeOrCone = classLvlCubeOrCone;
    
    if (armPositionState == ARM_POSITION_STATE_BEGIN) {

      ARM_POSITION_AT_FUNCTION_START = Arm.getWhichSideIsArm();
      if (ARM_POSITION_AT_FUNCTION_START == Arm.ROBOT_ARM_SIDE_FRONT) {
      }
      if (ARM_POSITION_AT_FUNCTION_START == Arm.ROBOT_ARM_SIDE_BACK) {
      }
    }
    //else if (armPositionState == ARM_POSITION_STATE_END) {
     // ARM_POSITION_AT_FUNCTION_START = Arm.ROBOT_ARM_SIDE_UNKNOWN;
    //}
  }
    

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {
  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {

    return ((armPositionState == ARM_POSITION_STATE_BEGIN && ARM_POSITION_AT_FUNCTION_START != Arm.ROBOT_ARM_SIDE_UNKNOWN) ||
            (armPositionState == ARM_POSITION_STATE_END));
    /*
    return ((armPositionState == ARM_POSITION_STATE_BEGIN && ARM_POSITION_AT_FUNCTION_START != Arm.ROBOT_ARM_SIDE_UNKNOWN) ||
            (armPositionState == ARM_POSITION_STATE_END && ARM_POSITION_AT_FUNCTION_START == Arm.ROBOT_ARM_SIDE_UNKNOWN));
    */
  }

  public static int getCubeOrCone() {
    return cubeOrCone;
  }
}
