// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands.armcommands;

import edu.wpi.first.hal.simulation.RoboRioDataJNI;
import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.CommandBase;
import frc.robot.Constants;
import frc.robot.RobotContainer;
import frc.robot.commands.armcommands.armsubcommands.ArmPositionStateCommand;
import frc.robot.subsystems.Arm;

public class ArmShelfPositionsCommand extends CommandBase {
  private boolean lightsAreOn = false;

  /** Creates a new Brake. */
  public ArmShelfPositionsCommand() {
    // Use addRequirements() here to declare subsystem dependencies.
    addRequirements(RobotContainer.armSubSystem);
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {
    
  }

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {
    
      int povHatDegs = Constants.OiConstants.operatorJoyStick.getPOV(0);
      if (povHatDegs == 0) {
        new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_BEGIN, ArmPositionStateCommand.CUBE);
        RobotContainer.armSubSystem.moveStageTwoToPos(Arm.ARM_STAGE_TWO_CUBE_SHELF.getPosition(Arm.ROBOT_ARM_SIDE_BACK));
        RobotContainer.armSubSystem.moveStageOneToPos(Arm.ARM_STAGE_ONE_CUBE_SHELF.getPosition(Arm.ROBOT_ARM_SIDE_BACK));
        RobotContainer.armSubSystem.moveStageThreeToPos(Arm.ARM_STAGE_THREE_CUBE_SHELF.getPosition(Arm.ROBOT_ARM_SIDE_BACK));
      }
      else if (povHatDegs == 180) {
        new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_BEGIN, ArmPositionStateCommand.CONE);
        RobotContainer.armSubSystem.moveStageTwoToPos(Arm.ARM_STAGE_TWO_CONE_SHELF.getPosition(Arm.ROBOT_ARM_SIDE_BACK));
        RobotContainer.armSubSystem.moveStageOneToPos(Arm.ARM_STAGE_ONE_CONE_SHELF.getPosition(Arm.ROBOT_ARM_SIDE_BACK));
        RobotContainer.armSubSystem.moveStageThreeToPos(Arm.ARM_STAGE_THREE_CONE_SHELF.getPosition(Arm.ROBOT_ARM_SIDE_BACK));
      }
      
      if (povHatDegs == 90) {
        lightsAreOn = true;
        RobotContainer.LedSubsystem.ledMode(RobotContainer.LedSubsystem.YELLOW_FLASH);
      }
      else if (povHatDegs == 270) {
        lightsAreOn = true;
        RobotContainer.LedSubsystem.ledMode(RobotContainer.LedSubsystem.PURPLE_FLASH);
      }
      else if (lightsAreOn) {
        lightsAreOn = false;
        if (DriverStation.getAlliance() == DriverStation.Alliance.Blue) {
        } else{
          if (DriverStation.getAlliance() == DriverStation.Alliance.Red) {
              RobotContainer.LedSubsystem.ledMode(0.61);
          }
        }
      }
  }
  

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {}

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {
    return false;
  }
}
