package frc.robot.commands.armcommands;

import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.Commands;
import edu.wpi.first.wpilibj2.command.ParallelCommandGroup;
import frc.robot.RobotContainer;
import frc.robot.commands.armcommands.armsubcommands.ArmPositionStateCommand;
import frc.robot.commands.armcommands.armsubcommands.ArmStageOneCommand;
import frc.robot.commands.armcommands.armsubcommands.ArmStageThreeCommand;
import frc.robot.commands.armcommands.armsubcommands.ArmStageTwoCommand;
import frc.robot.subsystems.Arm;

public class ArmCommandGroup extends ParallelCommandGroup {
    //public static final int ARM_TRANSITION_SIDES       = 3001;
    public static final int ARM_POSITION_ZERO            = 3002;
    public static final int ARM_CUBE_POSITION_HIGH       = 3003;
    public static final int ARM_CUBE_POSITION_MID        = 3004;
    public static final int ARM_CUBE_POSITION_LOW        = 3011;
    public static final int ARM_CUBE_POSITION_FLOOR      = 3005;
    /////
    public static final int ARM_CONE_POSITION_HIGH       = 3006;
    public static final int ARM_CONE_POSITION_MID        = 3007;
    public static final int ARM_CONE_POSITION_FLOOR      = 3008;
    /////
    public static final int ARM_OTT                      = 3009;
    public static final int ARM_TERMINAL                 = 3010;
    public static final int ARM_CONE_TERMINAL            = 3012;
    public static final int ARM_CUBE_SHELF               = 3013;
    public static final int ARM_CONE_SHELF               = 3014;

    public ArmCommandGroup(int targetPosition) {
        
        SmartDashboard.putString("Arm - ArmCommandGroup case: ", "");

        switch (targetPosition) { 

            case ARM_POSITION_ZERO :
                addCommands(Commands.sequence(new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_BEGIN, ArmPositionStateCommand.CUBE),
                                              new ArmStageOneCommand(Arm.ARM_STAGE_ONE_ZERO),
                                              Commands.parallel(new ArmStageThreeCommand(Arm.ARM_STAGE_THREE_ZERO),
                                                                new ArmStageTwoCommand(Arm.ARM_STAGE_TWO_ZERO)),
                                              new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_END, ArmPositionStateCommand.CUBE)));
                break;

            case ARM_CUBE_POSITION_HIGH :
                addCommands(Commands.sequence(new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_BEGIN,ArmPositionStateCommand.CUBE),
                                              Commands.parallel(new ArmStageTwoCommand(Arm.ARM_STAGE_TWO_CUBE_HIGH),
                                                                new ArmStageOneCommand(Arm.ARM_STAGE_ONE_CUBE_HIGH),
                                                                new ArmStageThreeCommand(Arm.ARM_STAGE_THREE_CUBE_HIGH)),                                              
                                              new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_END, ArmPositionStateCommand.CUBE)));
                break;

            case ARM_CUBE_POSITION_MID:
                addCommands(Commands.sequence(new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_BEGIN, ArmPositionStateCommand.CUBE ),
                                              Commands.parallel(new ArmStageTwoCommand(Arm.ARM_STAGE_TWO_CUBE_MID),
                                                                new ArmStageOneCommand(Arm.ARM_STAGE_ONE_CUBE_MID),
                                                                new ArmStageThreeCommand(Arm.ARM_STAGE_THREE_CUBE_MID)),
                                              new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_END, ArmPositionStateCommand.CUBE)));
                break;

            
            case ARM_CUBE_POSITION_LOW:
                addCommands(Commands.sequence(new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_BEGIN, ArmPositionStateCommand.CUBE),
                                              Commands.parallel(new ArmStageTwoCommand(Arm.ARM_STAGE_TWO_CUBE_LOW),
                                                                new ArmStageOneCommand(Arm.ARM_STAGE_ONE_CUBE_LOW),
                                                                new ArmStageThreeCommand(Arm.ARM_STAGE_THREE_CUBE_LOW)),
                                              new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_END, ArmPositionStateCommand.CUBE)));
                break; 

            case ARM_CUBE_POSITION_FLOOR:
                addCommands(Commands.sequence(new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_BEGIN, ArmPositionStateCommand.CUBE),
                                              Commands.parallel(new ArmStageTwoCommand(Arm.ARM_STAGE_TWO_CUBE_FLOOR),
                                                                new ArmStageOneCommand(Arm.ARM_STAGE_ONE_CUBE_FLOOR),
                                                                new ArmStageThreeCommand(Arm.ARM_STAGE_THREE_CUBE_FLOOR)),
                                              new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_END, ArmPositionStateCommand.CUBE)));
                break;


            case ARM_CONE_POSITION_HIGH :
                addCommands(Commands.sequence(new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_BEGIN, ArmPositionStateCommand.CONE),
                                              Commands.parallel(new ArmStageTwoCommand(Arm.ARM_STAGE_TWO_CONE_HIGH),
                                                                new ArmStageOneCommand(Arm.ARM_STAGE_ONE_CONE_HIGH),
                                                                new ArmStageThreeCommand(Arm.ARM_STAGE_THREE_CONE_HIGH)),
                                              new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_END, ArmPositionStateCommand.CONE)));
                break;

            case ARM_CONE_POSITION_MID:
                addCommands(Commands.sequence(new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_BEGIN, ArmPositionStateCommand.CONE),
                                              Commands.parallel(new ArmStageTwoCommand(Arm.ARM_STAGE_TWO_CONE_MID),
                                                                new ArmStageOneCommand(Arm.ARM_STAGE_ONE_CONE_MID),
                                                                new ArmStageThreeCommand(Arm.ARM_STAGE_THREE_CONE_MID)),
                                              new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_END, ArmPositionStateCommand.CONE)));
                break;

            case ARM_CONE_POSITION_FLOOR:
                addCommands(Commands.sequence(new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_BEGIN, ArmPositionStateCommand.CONE),
                                              Commands.parallel(new ArmStageTwoCommand(Arm.ARM_STAGE_TWO_CONE_FLOOR),
                                                                new ArmStageOneCommand(Arm.ARM_STAGE_ONE_CONE_FLOOR)),
                                                                new ArmStageThreeCommand(Arm.ARM_STAGE_THREE_CONE_FLOOR)),
                                              new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_END, ArmPositionStateCommand.CONE));
                break;

            // Human player station
            case ARM_TERMINAL:
                addCommands(Commands.sequence(new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_BEGIN, ArmPositionStateCommand.CUBE),
                                              Commands.parallel(new ArmStageTwoCommand(Arm.ARM_STAGE_TWO_TERMINAL),
                                                                new ArmStageOneCommand(Arm.ARM_STAGE_ONE_TERMINAL)),
                                                                new ArmStageThreeCommand(Arm.ARM_STAGE_THREE_TERMINAL),
                                              new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_END, ArmPositionStateCommand.CUBE)));
                break;

            
            case ARM_CONE_TERMINAL:
            addCommands(Commands.sequence(new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_BEGIN, ArmPositionStateCommand.CONE),
                                            Commands.parallel(new ArmStageTwoCommand(Arm.ARM_STAGE_TWO_CONE_TERMINAL),
                                                            new ArmStageOneCommand(Arm.ARM_STAGE_ONE_CONE_TERMINAL)),
                                                            new ArmStageThreeCommand(Arm.ARM_STAGE_THREE_CONE_TERMINAL),
                                            new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_END, ArmPositionStateCommand.CONE)));
            break;



            //// Shelf Positions

            case ARM_CUBE_SHELF:
            addCommands(Commands.sequence(new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_BEGIN, ArmPositionStateCommand.CUBE),
                                            Commands.parallel(new ArmStageTwoCommand(Arm.ARM_STAGE_TWO_CUBE_SHELF),
                                                            new ArmStageOneCommand(Arm.ARM_STAGE_ONE_CUBE_SHELF)),
                                                            new ArmStageThreeCommand(Arm.ARM_STAGE_THREE_CUBE_SHELF),
                                            new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_END, ArmPositionStateCommand.CUBE)));
            break;


            case ARM_CONE_SHELF:
            addCommands(Commands.sequence(new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_BEGIN, ArmPositionStateCommand.CONE),
                                            Commands.parallel(new ArmStageTwoCommand(Arm.ARM_STAGE_TWO_CONE_SHELF),
                                                            new ArmStageOneCommand(Arm.ARM_STAGE_ONE_CONE_SHELF)),
                                                            new ArmStageThreeCommand(Arm.ARM_STAGE_THREE_CONE_SHELF),
                                            new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_END, ArmPositionStateCommand.CONE)));
            break;


            // swap sides
            case ARM_OTT :
                addCommands(Commands.sequence(new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_BEGIN, ArmPositionStateCommand.CUBE),
                                              Commands.parallel(new ArmStageTwoCommand(Arm.ARM_STAGE_TWO_OTT),
                                                                new ArmStageOneCommand(Arm.ARM_STAGE_ONE_OTT),
                                                                new ArmStageThreeCommand(Arm.ARM_STAGE_THREE_OTT)),
                                              new ArmPositionStateCommand(ArmPositionStateCommand.ARM_POSITION_STATE_END, ArmPositionStateCommand.CUBE)));
                break;
            



            /*
            case ARM_OTT_TO_BK :

            // if the arm is on the back, over the top to the front
            addCommands(Commands.parallel(new ArmStageTwoCommand(Arm.ARM_STAGE_TWO_FROM_FR_OTT),
                                              new ArmStageOneCommand(Arm.ARM_STAGE_ONE_FROM_FR_OTT)),
                            new ArmStageThreeCommand(Arm.ARM_STAGE_THREE_FROM_FR_OTT));

            break;
            */
        }
    }
}
