// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands;

import java.net.ConnectException;

import edu.wpi.first.wpilibj2.command.CommandBase;
import frc.robot.RobotContainer;
import frc.robot.subsystems.IntakeSubsystem;

public class IntakePositionCommand extends CommandBase {
  /** Creates a new IntakePositionCommand. */
  boolean position = true;
  boolean buttonPressed = true;
  
  public IntakePositionCommand() {
    // Use addRequirements() here to declare subsystem dependencies.
    
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {}

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {
    int cube = IntakeSubsystem.CUBE_INTAKE_POSITION;
    int cone = IntakeSubsystem.CONE_INTAKE_POSITION;
    
    //if(!buttonPressed){
    if(RobotContainer.intakeSubSystem.getCurrentIntakePosition() == cone ) {
      RobotContainer.intakeSubSystem.moveIntakeToPosition(cube);
    } else if(RobotContainer.intakeSubSystem.getCurrentIntakePosition() == cube){
      RobotContainer.intakeSubSystem.moveIntakeToPosition(cone);
    }
    buttonPressed =true;
  //} else {
  //  buttonPressed = false;
  //}
  }

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {}

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {
    return true;
  }
}
