// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands;

import frc.robot.RobotContainer;
import frc.robot.subsystems.IntakeSubsystem;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.CommandBase;

/** An example command that uses an example subsystem. */
public class IntakePistonCommand extends CommandBase {

    public static final int INTAKE_STATE_CLOSE = 4001;
    public static final int INTAKE_STATE_OPEN = 4002;
    public static final int INTAKE_STATE_NEUTRAL = 4003;

    private int intakeState = INTAKE_STATE_NEUTRAL;
  
  /** Creates a new VisionTestCommand. */
  public IntakePistonCommand(int intakeState) {
    // Use addRequirements() here to declare subsystem dependencies.
    //addRequirements(RobotContainer.intakeSubSystem);
    this.intakeState = intakeState;
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {
  }

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {
    switch (intakeState) {

      case INTAKE_STATE_CLOSE :
          RobotContainer.intakeSubSystem.shutIntake();
          break;
      
      case INTAKE_STATE_OPEN :
          RobotContainer.intakeSubSystem.openIntake();
          break;
      
      case INTAKE_STATE_NEUTRAL :
          RobotContainer.intakeSubSystem.allStop();
          break;
    }
  }

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {
    RobotContainer.intakeSubSystem.openIntake();
  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {
    return false;
  }
}