// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands;

import frc.robot.RobotContainer;
import frc.robot.commands.armcommands.ArmCommandGroup;
import frc.robot.commands.armcommands.armsubcommands.ArmPositionStateCommand;
import frc.robot.subsystems.IntakeSubsystem;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.CommandBase;

/** An example command that uses an example subsystem. */
public class IntakeCommand extends CommandBase {

    public static final int INTAKE_STATE_CLOSE = 4001;
    public static final int INTAKE_STATE_OPEN = 4002;
    public static final int INTAKE_STATE_NEUTRAL = 4003;

    private int intakeState = INTAKE_STATE_NEUTRAL;
  
  /** Creates a new VisionTestCommand. */
  public IntakeCommand(int intakeState) {
    // Use addRequirements() here to declare subsystem dependencies.
    //addRequirements(RobotContainer.intakeSubSystem);
    this.intakeState = intakeState;
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {
  }

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {

    SmartDashboard.putNumber("Intake - IntakeCommand execute intakeState: ", intakeState);
   
    switch (intakeState) {

      case INTAKE_STATE_CLOSE :
          //RobotContainer.intakeSubSystem.openIntake();
          //new ArmCommandGroup(ArmCommandGroup.ARM_POSITION_ZERO);
          
          if(ArmPositionStateCommand.cubeOrCone == ArmPositionStateCommand.CUBE){
            RobotContainer.intakeSubSystem.engageIntake(IntakeSubsystem.INTAKE_DIRECTION_REVERSE);
          }else {
            RobotContainer.intakeSubSystem.engageIntake(IntakeSubsystem.INTAKE_DIRECTION_FORWARD);
          }
         
          break;
      
      case INTAKE_STATE_OPEN :
          //new ArmCommandGroup(ArmCommandGroup.ARM_CUBE_POSITION_FLOOR);
          RobotContainer.intakeSubSystem.openIntake();
          if(ArmPositionStateCommand.cubeOrCone == ArmPositionStateCommand.CUBE){
            RobotContainer.intakeSubSystem.engageIntake(IntakeSubsystem.INTAKE_DIRECTION_FORWARD);
          }else {
            RobotContainer.intakeSubSystem.engageIntake(IntakeSubsystem.INTAKE_DIRECTION_REVERSE);
          }
          break;
      
      case INTAKE_STATE_NEUTRAL :
          RobotContainer.intakeSubSystem.allStop();
          break;
    }
  }

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {
    RobotContainer.intakeSubSystem.allStop();
    RobotContainer.intakeSubSystem.shutIntake();
  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {
    return false;
  }
}