// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands;

import frc.robot.Constants;
import frc.robot.RobotContainer;
import frc.robot.subsystems.Arm;
import frc.robot.subsystems.ExampleSubsystem;

import com.ctre.phoenix.motorcontrol.ControlMode;

import edu.wpi.first.wpilibj2.command.CommandBase;

/** An example command that uses an example subsystem. */
public class ExampleCommand extends CommandBase {

  private int theCount = 0;
  private String name;
  private int position;
  //@SuppressWarnings({"PMD.UnusedPrivateField", "PMD.SingularField"})
  //private final ExampleSubsystem m_subsystem;

  /**
   * Creates a new ExampleCommand.
   *
   * @param subsystem The subsystem used by this command.
   */
  public ExampleCommand(String name, int position) {

    this.name = name;
    this.position = position;


    //m_subsystem = subsystem;
    // Use addRequirements() here to declare subsystem dependencies.
    //addRequirements(subsystem);
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {
    theCount = 0;
  }

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {

    ++theCount;
    //System.out.println("---------------------------------- theCount="+(++theCount));
    //Arm.stageTwo.set(ControlMode.PercentOutput, 0.15);

    Arm.stageTwo.configMotionAcceleration(Constants.ArmConstants.CRUISE_VELOCITY_ACCEL_UP, 0);
    Arm.stageTwo.configMotionCruiseVelocity(Constants.ArmConstants.CRUISE_VELOCITY_ACCEL_UP, 0);
    Arm.stageTwo.set(ControlMode.MotionMagic, position);

    System.out.println("---------------------------------- "+name+" Pos=="+Arm.stageTwo.getSelectedSensorPosition());

  }

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {
    System.out.println("---------------------------------- "+name+" ExampleCommand ENDING");
  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {

    //18957.0
    boolean isFinished = false;
    if (position == 0 && Arm.stageTwo.getSelectedSensorPosition() < 300) {
      isFinished = true;
    }
    else if (position == 80000 && Arm.stageTwo.getSelectedSensorPosition() > 79000) {
      isFinished = true;
    }

    return isFinished;
    //return (theCount >=50);
  }
}
