// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands;

import edu.wpi.first.hal.simulation.RoboRioDataJNI;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.CommandBase;
import frc.robot.RobotContainer;
import frc.robot.subsystems.Arm;

public class BrakeCommand extends CommandBase {
  private boolean brakeOn = false;

  /** Creates a new Brake. */
  public BrakeCommand(boolean brakeOn) {
    // Use addRequirements() here to declare subsystem dependencies.
    this.brakeOn = brakeOn;
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {}

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {
    if (brakeOn) {
      RobotContainer.armSubSystem.toggleBreakMode(true);
    }
    else {
      RobotContainer.armSubSystem.toggleBreakMode(false);
    }
  }

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {}

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {
    return false;
  }
}
