package frc.robot.commands.autonomouscommands.autosubcommands;

import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.CommandBase;
import frc.robot.AutoMultiBallCommandGroup;
import frc.robot.Constants;
import frc.robot.RobotContainer;
import frc.robot.commands.armcommands.ArmCommandGroup;
import frc.robot.subsystems.Arm;
import frc.robot.subsystems.Drivetrain;
import frc.robot.subsystems.Gyro;
import frc.robot.subsystems.IntakeSubsystem;

public class AutonomousScoreCube extends CommandBase {
    private Gyro gyro = new Gyro();
    private boolean driveComplete = false;
  
    int loopIterations = 0;
    public AutonomousScoreCube() {
      // Use addRequirements() here to declare subsystem dependencies.
      addRequirements(RobotContainer.drivetrainSubSystem);
      //addRequirements(RobotContainer.armSubSystem);
    }
  
    // Called when the command is initially scheduled.
    @Override
    public void initialize() {
      loopIterations = 0;
      
    }
  
    // Called every time the scheduler runs while the command is scheduled.
    @Override
    public void execute() {

      switch(loopIterations){

          // Open Intake to catch piece perched atop
        case(0):
          //RobotContainer.intakeSubSystem.openIntake();
          //RobotContainer.intakeSubSystem.engageIntake(IntakeSubsystem.INTAKE_DIRECTION_REVERSE);
          break;

          // Extend arm to score position 
        case(1): // 1 second later 
        
           //new ArmCommandGroup(ArmCommandGroup.ARM_CUBE_POSITION_MID);
           RobotContainer.armSubSystem.moveStageOneToPos(Arm.ARM_STAGE_ONE_CONE_HIGH.getPosition(Arm.ROBOT_ARM_SIDE_FRONT));
           RobotContainer.armSubSystem.moveStageTwoToPos(Arm.ARM_STAGE_TWO_CONE_HIGH.getPosition(Arm.ROBOT_ARM_SIDE_FRONT));
           RobotContainer.armSubSystem.moveStageThreeToPos(Arm.ARM_STAGE_THREE_CONE_HIGH.getPosition(Arm.ROBOT_ARM_SIDE_FRONT));
           
          break;

          // stop and expel game piece
        case (120): // 1 second later
          //RobotContainer.drivetrainSubSystem.Move(0.0, 0.0); 
          RobotContainer.intakeSubSystem.engageIntake(IntakeSubsystem.INTAKE_DIRECTION_FORWARD);
          break;

          // Move back to starting position
        case(190): // 1/2 second later
          RobotContainer.intakeSubSystem.engageIntake(0);
          RobotContainer.armSubSystem.moveStageOneToPos(Arm.ARM_STAGE_ONE_ZERO.getPosition(Arm.ROBOT_ARM_SIDE_BACK));
          RobotContainer.armSubSystem.moveStageTwoToPos(Arm.ARM_STAGE_TWO_ZERO.getPosition(Arm.ROBOT_ARM_SIDE_BACK));
          RobotContainer.armSubSystem.moveStageThreeToPos(Arm.ARM_STAGE_THREE_ZERO.getPosition(Arm.ROBOT_ARM_SIDE_BACK));
          driveComplete = true;

          // Stop and retract arm
          break;
      }
      loopIterations++;
    }
  
    // Called once the command ends or is interrupted.
    @Override
    public void end(boolean interrupted) {
      RobotContainer.drivetrainSubSystem.Move(0.0, 0.0);
      //RobotContainer.drivetrainSubSystem.setDriveMotorMode(Drivetrain.NEUTRALMODE_COAST);

      loopIterations = 0;
      driveComplete = true;
      SmartDashboard.putBoolean("AutoGyro - Shutting Down", true);
    }
  
    // Returns true when the command should end.
    @Override
    public boolean isFinished() {
      return driveComplete;
    }
  }
  