package frc.robot.commands.autonomouscommands.autosubcommands;

import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.CommandBase;
import frc.robot.Constants;
import frc.robot.RobotContainer;
import frc.robot.subsystems.Drivetrain;
import frc.robot.subsystems.Gyro;

public class AutonomousNeuZoneBalance extends CommandBase {
    private Gyro gyro = new Gyro();
    private boolean driveComplete = false;
    
    private boolean onFrontOfTable = false;
    private boolean onBackOfTable = false;
    private boolean onNeutralZoneFloor = false;
    private int loopIterations;
    private int loopIterationsInNeuZone;

    public AutonomousNeuZoneBalance() {
      // Use addRequirements() here to declare subsystem dependencies.
      addRequirements(RobotContainer.drivetrainSubSystem);
    }
  
    // Called when the command is initially scheduled.
    @Override
    public void initialize() {
      loopIterations = 0;
      loopIterationsInNeuZone = 0;
      driveComplete = false;
      onFrontOfTable = false;
      onBackOfTable = false;
      onNeutralZoneFloor = false;

      
      SmartDashboard.putBoolean("AutoGyro - onFrontOfTable=", false);
      SmartDashboard.putBoolean("AutoGyro - onBackOfTable=", false);
      SmartDashboard.putBoolean("AutoGyro - onNeutralZoneFloor=", false);
      SmartDashboard.putBoolean("AutoGyro - driveComplete=", false);

    }
  
    // Called every time the scheduler runs while the command is scheduled.
    @Override
    public void execute() {

      SmartDashboard.putNumber("AutoGyro - Actual Pitch=", gyro.getPitch());

      switch(loopIterations){
        case(5):
          RobotContainer.drivetrainSubSystem.Move(-0.25, 
                                                  -0.25); // move to engage the table
          RobotContainer.drivetrainSubSystem.setDriveMotorMode(Drivetrain.NEUTRALMODE_BRAKE);
            break;
        case(700): // all stop
          RobotContainer.drivetrainSubSystem.Move(0.0, 0.0);
          driveComplete = true;
          break;
      }

      // go out to neutral zone
      
      if (!onFrontOfTable && gyro.getPitch() > 9) {
        SmartDashboard.putBoolean("AutoGyro - onFrontOfTable=", true);

        onFrontOfTable = true;
      }
      else if (onFrontOfTable && !onBackOfTable && gyro.getPitch() < 8) {
        SmartDashboard.putBoolean("AutoGyro - onBackOfTable=", true);
        onBackOfTable = true;
      }
      else if (onFrontOfTable && onBackOfTable && !onNeutralZoneFloor && (gyro.getPitch() > -3 && gyro.getPitch() < 3)) {
        SmartDashboard.putBoolean("AutoGyro - onNeutralZoneFloor=", true);
        onNeutralZoneFloor = true;

      }
      else if (onFrontOfTable && onBackOfTable && onNeutralZoneFloor && loopIterationsInNeuZone++ > 10) {
        SmartDashboard.putNumber("AutoGyro - loopIterationsInNeuZone=", loopIterationsInNeuZone);
        SmartDashboard.putBoolean("AutoGyro - driveComplete=", true);
        driveComplete = true;
      }

      loopIterations++;
    }
  
    // Called once the command ends or is interrupted.
    @Override
    public void end(boolean interrupted) {
      RobotContainer.drivetrainSubSystem.Move(0.0, 0.0);

      loopIterations = 0;
      loopIterationsInNeuZone = 0;
      SmartDashboard.putBoolean("AutoGyro - Shutting Down", true);
    }
  
    // Returns true when the command should end.
    @Override
    public boolean isFinished() {
      return driveComplete;
    }
  }
  