package frc.robot.commands.autonomouscommands.autosubcommands;

import javax.lang.model.util.ElementScanner14;

import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.CommandBase;
import frc.robot.Constants;
import frc.robot.RobotContainer;
import frc.robot.subsystems.Drivetrain;
import frc.robot.subsystems.Gyro;
import frc.robot.subsystems.IntakeSubsystem;

public class AutonomousNeuZone extends CommandBase {
    private Gyro gyro = new Gyro();
    private boolean reverseDirection;
    private boolean driveComplete = false;
  
    int loopIterations;
    public AutonomousNeuZone() {
      // Use addRequirements() here to declare subsystem dependencies.
      addRequirements(RobotContainer.drivetrainSubSystem);
    }
    public AutonomousNeuZone(boolean reverseDirection) {
      // Use addRequirements() here to declare subsystem dependencies.
      addRequirements(RobotContainer.drivetrainSubSystem);
      this.reverseDirection = reverseDirection;
    }
  
    // Called when the command is initially scheduled.
    @Override
    public void initialize() {
      loopIterations = 0;
      
    }
  
    // Called every time the scheduler runs while the command is scheduled.
    @Override
    public void execute() {

      SmartDashboard.putNumber("AutoGyro - Actual Pitch=", gyro.getPitch());

      switch(loopIterations){
        case (5):
          //RobotContainer.intakeSubSystem.engageIntake(IntakeSubsystem.INTAKE_DIRECTION_REVERSE);
          /**
           * Disabled for Governor's Cup
           */
        case(25):
        
          RobotContainer.drivetrainSubSystem.Move(Constants.AutoBalanceConstants.CHARGE_STATION_FWD_SPEED * -1, // also changed for governor's cup
                                                  Constants.AutoBalanceConstants.CHARGE_STATION_FWD_SPEED * -1); // move to engage the table
          RobotContainer.drivetrainSubSystem.setDriveMotorMode(Drivetrain.NEUTRALMODE_BRAKE);

            break;
        case (100):
          RobotContainer.intakeSubSystem.allStop(); 
          break;
        case(Constants.AutoBalanceConstants.AUTO_OUT_ONLY_TIMEOUT_ITERATIONS):
          RobotContainer.drivetrainSubSystem.Move(0.0, 0.0);

        break;
      }

      loopIterations++;
    }
  
    // Called once the command ends or is interrupted.
    @Override
    public void end(boolean interrupted) {
      RobotContainer.drivetrainSubSystem.Move(0.0, 0.0);
      //RobotContainer.drivetrainSubSystem.setDriveMotorMode(Drivetrain.NEUTRALMODE_COAST);

      loopIterations = 0;
      driveComplete = true;
      SmartDashboard.putBoolean("AutoGyro - Shutting Down", true);
    }
  
    // Returns true when the command should end.
    @Override
    public boolean isFinished() {
      return driveComplete;
    }
  }
  