package frc.robot.commands.autonomouscommands.autosubcommands;

import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.CommandBase;
import frc.robot.Constants;
import frc.robot.RobotContainer;
import frc.robot.subsystems.Drivetrain;
import frc.robot.subsystems.Gyro;

public class AutonomousBalance extends CommandBase {
    private Gyro gyro = new Gyro();
    private boolean driveComplete = false;
    private long onTableStartTime = 0;
    private boolean robotOnTippedTable = false;
    private int iterationsAtTippingPoint = 0;
    private boolean achievedTablePitch = false;
  
    private int loopIterations;
    public AutonomousBalance() {
      // Use addRequirements() here to declare subsystem dependencies.
      addRequirements(RobotContainer.drivetrainSubSystem);
    }
  
    // Called when the command is initially scheduled.
    @Override
    public void initialize() {
      loopIterations = 0;
      onTableStartTime = 0;
      
      SmartDashboard.putNumber("AutoGyro - Actual Pitch=", 0);
      SmartDashboard.putBoolean("AutoGyro - Achived table pitch", false);
      SmartDashboard.putBoolean("AutoGyro - Achieved table pitch", false);
      SmartDashboard.putBoolean("AutoGyro - robotOnTippedTable", false);
      SmartDashboard.putNumber("AutoGyro - Time on table=", 0);
      SmartDashboard.putBoolean("AutoGyro - Tilt detected=", false);
      SmartDashboard.putBoolean("AutoGyro - backing up", false);
      SmartDashboard.putBoolean("AutoGyro - Drive Complete", false);
      SmartDashboard.putBoolean("AutoGyro - Shutting Down", false);
      SmartDashboard.putNumber("AutoGyro - iterationsAtTippingPoint=", 0);
      SmartDashboard.putNumber("AutoGyro - backup iterations=", 0);
      SmartDashboard.putNumber("AutoGyro - Time on table=", (System.currentTimeMillis() - onTableStartTime));
    }
  
    // Called every time the scheduler runs while the command is scheduled.
    @Override
    public void execute() {


      SmartDashboard.putNumber("AutoGyro - Actual Pitch=", gyro.getPitch());


      switch(loopIterations){
        case(5):
          RobotContainer.drivetrainSubSystem.Move(Constants.AutoBalanceConstants.CHARGE_STATION_FWD_SPEED, 
                                                  Constants.AutoBalanceConstants.CHARGE_STATION_FWD_SPEED); // move to engage the table
          RobotContainer.drivetrainSubSystem.setDriveMotorMode(Drivetrain.NEUTRALMODE_BRAKE);
            break;
        //case(Constants.AutoBalanceConstants.AUTONOMOUSE_TIMEOUT_ITERATIONS): // all stop
        case(700): // all stop
          RobotContainer.drivetrainSubSystem.Move(0.0, 0.0);
          driveComplete = true;
          break;
      }

      if ((gyro.getPitch() > (Constants.AutoBalanceConstants.CHARGE_STATION_TILT_DEG - Constants.AutoBalanceConstants.CHARGE_STATION_PITCH_MOE) )
           &&
           (gyro.getPitch() < (Constants.AutoBalanceConstants.CHARGE_STATION_TILT_DEG + Constants.AutoBalanceConstants.CHARGE_STATION_PITCH_MOE)))
      {
          if (onTableStartTime == 0) {
              onTableStartTime = System.currentTimeMillis();
              achievedTablePitch = true;
              SmartDashboard.putBoolean("AutoGyro - Achived table pitch", true);
              SmartDashboard.putBoolean("AutoGyro - Achieved table pitch", achievedTablePitch);
          }
          else if ((System.currentTimeMillis() - onTableStartTime) >= Constants.AutoBalanceConstants.CHARGE_STATION_MIN_TABLE_TIME_MS) {
            robotOnTippedTable = true;
            SmartDashboard.putBoolean("AutoGyro - robotOnTippedTable", robotOnTippedTable);
          }
          
          if (onTableStartTime > 0) {
            SmartDashboard.putNumber("AutoGyro - Time on table=", (System.currentTimeMillis() - onTableStartTime));
          }
          else {
            SmartDashboard.putNumber("AutoGyro - Time on table=", 0);
          }

      }
      else {
        onTableStartTime = 0;
      }

      // 
      if (robotOnTippedTable && (gyro.getPitch() < (Constants.AutoBalanceConstants.CHARGE_STATION_TILT_DEG - Constants.AutoBalanceConstants.CHARGE_STATION_PITCH_MOE))) {
        SmartDashboard.putBoolean("AutoGyro - Tilt detected=", true);
        if (iterationsAtTippingPoint == 0) {
          iterationsAtTippingPoint = loopIterations;
        }
      }

      if (iterationsAtTippingPoint > 0) {
        
        SmartDashboard.putBoolean("AutoGyro - backing up", true);
        RobotContainer.drivetrainSubSystem.Move(-Constants.AutoBalanceConstants.CHARGE_STATION_FWD_SPEED, 
                                                -Constants.AutoBalanceConstants.CHARGE_STATION_FWD_SPEED); // move to engage the table

        if (loopIterations >= iterationsAtTippingPoint + Constants.AutoBalanceConstants.CHARGE_STATION_REVERSE_ITERATIONS) {
            RobotContainer.drivetrainSubSystem.Move(0.0, 0.0);
            SmartDashboard.putBoolean("AutoGyro - Drive Complete", true);
            driveComplete = true;
        }
        else {
          SmartDashboard.putNumber("AutoGyro - iterationsAtTippingPoint=", iterationsAtTippingPoint);
          SmartDashboard.putNumber("AutoGyro - backup iterations=", loopIterations);
        }
      }
      
      loopIterations++;
    }
  
    // Called once the command ends or is interrupted.
    @Override
    public void end(boolean interrupted) {
      RobotContainer.drivetrainSubSystem.Move(0.0, 0.0);
      //RobotContainer.drivetrainSubSystem.setDriveMotorMode(Drivetrain.NEUTRALMODE_COAST);

      driveComplete = true;
      robotOnTippedTable = false;
      iterationsAtTippingPoint = 0;
      SmartDashboard.putBoolean("AutoGyro - Shutting Down", true);
    }
  
    // Returns true when the command should end.
    @Override
    public boolean isFinished() {
      return driveComplete;
    }
  }
  