package frc.robot.commands.autonomouscommands;

import edu.wpi.first.wpilibj2.command.SequentialCommandGroup;
import frc.robot.commands.autonomouscommands.autosubcommands.AutonomousBalance;
import frc.robot.commands.autonomouscommands.autosubcommands.AutonomousNeuZone;
import frc.robot.commands.autonomouscommands.autosubcommands.AutonomousNeuZoneBalance;
import frc.robot.commands.autonomouscommands.autosubcommands.AutonomousScoreCube;
import frc.robot.commands.autonomouscommands.autosubcommands.AutonomousNeuZone;

public class AutoMultiTaskCommandGroup extends SequentialCommandGroup {

    public static final int AUTO_CENTER_BALANCE_ONLY = 1;
    public static final int AUTO_BALANCE_OVER_AND_BACK = 2;
    public static final int AUTO_SCORE_ONLY = 3;
    public static final int AUTO_SCORE_BALANCE_OVER_AND_BACK = 4;
    public static final int AUTO_SCORE_OUT = 5;

    public AutoMultiTaskCommandGroup(int selctedAuto) {
        // Add your commands in the addCommands() call, e.g.
        // addCommands(new FooCommand(), new BarCommand());
        //addCommands(new AutoTargetAndShoot(true));
        // shoots the preloaded ball
        
        if (selctedAuto == AUTO_CENTER_BALANCE_ONLY) {
          addCommands(new AutonomousBalance());
                      this.setName("AUTO_CENTER_BALANCE_ONLY");
        } else if (selctedAuto == AUTO_BALANCE_OVER_AND_BACK){

          addCommands(new AutonomousNeuZoneBalance()
                      ,new AutonomousBalance()
                      );
          this.setName("AUTO_BALANCE_OVER_AND_BACK");
          
        } else if (selctedAuto == AUTO_SCORE_ONLY) {
          addCommands(new AutonomousScoreCube());
        } else if (selctedAuto == AUTO_SCORE_BALANCE_OVER_AND_BACK)
        {
          addCommands(new AutonomousScoreCube(),
                      new AutonomousNeuZoneBalance(),
                      new AutonomousBalance());
        } else if (selctedAuto == AUTO_SCORE_OUT)
        {
          addCommands(new AutonomousScoreCube(),
                      new AutonomousNeuZone());
          this.setName("AUTO_SCORE_OUT");
        } 
        else {
          this.setName("AUTO_NONE");
        }
      }

}