// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot;

import frc.robot.Constants.OiConstants;
import frc.robot.commands.AprilTagTrackCommand;
import frc.robot.commands.ArcadeDriveCommand;
import frc.robot.commands.BrakeCommand;
import frc.robot.commands.DriveBrakeMode;
import frc.robot.commands.ExampleCommand;
import frc.robot.commands.ExampleCommandGroup;
import frc.robot.commands.GamepieceTrackCommand;
import frc.robot.commands.IntakeCommand;
import frc.robot.commands.IntakePistonCommand;
import frc.robot.commands.IntakePositionCommand;
import frc.robot.commands.VisionTestCommand;
import frc.robot.commands.WristOverrideCommand;
import frc.robot.commands.ledCommand;
import frc.robot.commands.armcommands.ArmCommandGroup;
import frc.robot.commands.armcommands.ArmShelfPositionsCommand;
import frc.robot.commands.armcommands.armsubcommands.ArmCalibrationCommand;
import frc.robot.commands.armcommands.armsubcommands.ArmStageOneCommand;
import frc.robot.commands.armcommands.armsubcommands.ArmStageTwoCommand;
import frc.robot.commands.autonomouscommands.AutoMultiTaskCommandGroup;
import frc.robot.commands.autonomouscommands.autosubcommands.AutonomousNeuZone;
import frc.robot.commands.autonomouscommands.autosubcommands.AutonomousNothing;
import frc.robot.subsystems.Arm;
import frc.robot.subsystems.Drivetrain;
import frc.robot.subsystems.Gyro;
import frc.robot.subsystems.IntakeSubsystem;
import frc.robot.subsystems.OperatorInterface;
import frc.robot.subsystems.Vision;
import frc.robot.subsystems.leds;
import edu.wpi.first.wpilibj2.command.button.JoystickButton;
import edu.wpi.first.wpilibj.smartdashboard.SendableChooser;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.Command;
import edu.wpi.first.wpilibj2.command.button.CommandXboxController;
import edu.wpi.first.wpilibj2.command.button.Trigger;


/**
 * This class is where the bulk of the robot should be declared. Since Command-based is a
 * "declarative" paradigm, very little robot logic should actually be handled in the {@link Robot}
 * periodic methods (other than the scheduler calls). Instead, the structure of the robot (including
 * subsystems, commands, and trigger mappings) should be declared here.
 */
public class RobotContainer {
  // The robot's subsystems and commands are defined here...
  public static final Drivetrain drivetrainSubSystem = new Drivetrain();
  public static final Gyro gyro = new Gyro();
  public static final OperatorInterface OperatorInterface = new OperatorInterface();
  public static final Vision visionSubSystem = new Vision();
  public static final Arm armSubSystem = new Arm();
  public static final IntakeSubsystem intakeSubSystem = new IntakeSubsystem();
  public static final leds LedSubsystem  = new leds();

  // A chooser for autonomous commands
  public static SendableChooser<Command> autonomousChooser = new SendableChooser<>();
    
  /** The container for the robot. Contains subsystems, OI devices, and commands. */
  public RobotContainer() {
    // Configure the trigger bindings
    configureBindings();

    // Default commands
    //visionSubSystem.setDefaultCommand(new VisionTestCommand() );
    armSubSystem.setDefaultCommand(new ArmCalibrationCommand(2, 0));

    // This default command will keep the drivetrain running through the program.
    drivetrainSubSystem.setDefaultCommand(new ArcadeDriveCommand());
    armSubSystem.setDefaultCommand(new ArmShelfPositionsCommand());

    // Dashboard Autonomous chooser selections
    autonomousChooser.setDefaultOption("Auto Balance", new AutoMultiTaskCommandGroup(AutoMultiTaskCommandGroup.AUTO_CENTER_BALANCE_ONLY));
    autonomousChooser.addOption("Auto Balance over and back", new AutoMultiTaskCommandGroup(AutoMultiTaskCommandGroup.AUTO_BALANCE_OVER_AND_BACK));
    autonomousChooser.addOption("Auto Nue Zone", new AutonomousNeuZone());
    autonomousChooser.addOption("Auto Score Cone balance over and back", new AutoMultiTaskCommandGroup(AutoMultiTaskCommandGroup.AUTO_SCORE_BALANCE_OVER_AND_BACK));
    autonomousChooser.addOption("Auto Score Cone and Out", new AutoMultiTaskCommandGroup(AutoMultiTaskCommandGroup.AUTO_SCORE_OUT));
    autonomousChooser.addOption("Auto Do Nothing", new AutonomousNothing());

    SmartDashboard.putData("Auto Mode", autonomousChooser);
  }

  /**
   * Use this method to define your trigger->command mappings. Triggers can be created via the
   * {@link Trigger#Trigger(java.util.function.BooleanSupplier)} constructor with an arbitrary
   * predicate, or via the named factories in {@link
   * edu.wpi.first.wpilibj2.command.button.CommandGenericHID}'s subclasses for {@link
   * CommandXboxController Xbox}/{@link edu.wpi.first.wpilibj2.command.button.CommandPS4Controller
   * PS4} controllers or {@link edu.wpi.first.wpilibj2.command.button.CommandJoystick Flight
   * joysticks}.
   */
  private void configureBindings() {
    
    new JoystickButton(Constants.OiConstants.operatorJoyStick,
                       Constants.OiConstants.CALIBRATE_PNEUM_SHUT_BUTTON).whileTrue(new IntakeCommand(IntakeCommand.INTAKE_STATE_CLOSE));
    new JoystickButton(Constants.OiConstants.operatorJoyStick, 
                       Constants.OiConstants.CALIBRATE_PNEUM_OPEN_BUTTON).whileTrue(new IntakeCommand(IntakeCommand.INTAKE_STATE_OPEN));

    //////////////// Arm Positions
    new JoystickButton(Constants.OiConstants.operatorJoyStick, 
                       Constants.OiConstants.ARM_POSITION_ZERO_BUTTON).onTrue(new ArmCommandGroup(ArmCommandGroup.ARM_POSITION_ZERO));

    // Cube positions
    new JoystickButton(Constants.OiConstants.operatorJoyStick, 
                       Constants.OiConstants.ARM_POSITION_CUBE_HIGH_BUTTON).onTrue(new ArmCommandGroup(ArmCommandGroup.ARM_CUBE_POSITION_HIGH));

    new JoystickButton(Constants.OiConstants.operatorJoyStick, 
                       Constants.OiConstants.ARM_POSITION_CUBE_MID_BUTTON).onTrue(new ArmCommandGroup(ArmCommandGroup.ARM_CUBE_POSITION_MID));

                       
    new JoystickButton(Constants.OiConstants.operatorJoyStick, 
                      Constants.OiConstants.ARM_POSITION_CUBE_LOW_BUTTON).onTrue(new ArmCommandGroup(ArmCommandGroup.ARM_CUBE_POSITION_LOW));
    
    new JoystickButton(Constants.OiConstants.operatorJoyStick, 
                       Constants.OiConstants.ARM_POSITION_CUBE_FLOOR_BUTTON).onTrue(new ArmCommandGroup(ArmCommandGroup.ARM_CUBE_POSITION_FLOOR));


    // Cone positions
    new JoystickButton(Constants.OiConstants.operatorJoyStick, 
                       Constants.OiConstants.ARM_POSITION_CONE_HIGH_BUTTON).onTrue(new ArmCommandGroup(ArmCommandGroup.ARM_CONE_POSITION_HIGH));

    new JoystickButton(Constants.OiConstants.operatorJoyStick, 
                       Constants.OiConstants.ARM_POSITION_CONE_MID_BUTTON).onTrue(new ArmCommandGroup(ArmCommandGroup.ARM_CONE_POSITION_MID));
    
    new JoystickButton(Constants.OiConstants.operatorJoyStick, 
                       Constants.OiConstants.ARM_POSITION_CONE_FLOOR_BUTTON).onTrue(new ArmCommandGroup(ArmCommandGroup.ARM_CONE_POSITION_FLOOR));

    // Terminal 
    new JoystickButton(Constants.OiConstants.operatorJoyStick, 
                       Constants.OiConstants.ARM_POSITION_TERMINAL_BUTTON).onTrue(new ArmCommandGroup(ArmCommandGroup.ARM_TERMINAL));

    //new JoystickButton(Constants.OiConstants.operatorJoyStick, 
    //                   Constants.OiConstants.ARM_POSITION_OTT).whileTrue(new ArmCommandGroup(ArmCommandGroup.ARM_CONE_TERMINAL));



    //new JoystickButton(Constants.OiConstants.operatorJoyStick, Constants.OiConstants.operatorJoyStick.getPOV(0)).whileTrue(new ArmCommandGroup(ArmCommandGroup.ARM_CUBE_SHELF));
    //new JoystickButton(Constants.OiConstants.operatorJoyStick, Constants.OiConstants.operatorJoyStick.getPOV(5)).whileTrue(new ArmCommandGroup(ArmCommandGroup.ARM_CUBE_SHELF));

    //new JoystickButton(Constants.OiConstants.operatorJoyStick, Constants.OiConstants.operatorJoyStick.getPOV(0)).whileTrue(new IntakeCommand(IntakeCommand.INTAKE_STATE_CLOSE));
    //new JoystickButton(Constants.OiConstants.operatorJoyStick, Constants.OiConstants.operatorJoyStick.getPOV(5)).whileTrue(new IntakeCommand(IntakeCommand.INTAKE_STATE_OPEN));


    new JoystickButton(Constants.OiConstants.driverJoyStick,
                       Constants.OiConstants.DRIVE_LED_BLUE).whileTrue(new ledCommand(3));
                       
    new JoystickButton(Constants.OiConstants.driverJoyStick,
                       Constants.OiConstants.DRIVE_LED_YELLOW).whileTrue(new ledCommand(1));
    
                       
    // Over the Top
    new JoystickButton(Constants.OiConstants.operatorJoyStick, 
                        Constants.OiConstants.ARM_POSITION_OTT).onTrue(new ArmCommandGroup(ArmCommandGroup.ARM_OTT));
    
    new JoystickButton(Constants.OiConstants.driverJoyStick, 
                       11).whileTrue( new ledCommand(ledCommand.PURPLE_FLASH));
    new JoystickButton(Constants.OiConstants.driverJoyStick, 
                      12).whileTrue( new ledCommand(ledCommand.YELLOW_FLASH));
                      /*
                      new JoystickButton(Constants.OiConstants.driverJoyStick, 
                                         Constants.OiConstants.DRIVE_LED_BLUE).whileTrue( new ledCommand(ledCommand.PURPLE_FLASH));
                      new JoystickButton(Constants.OiConstants.driverJoyStick, 
                                        Constants.OiConstants.DRIVE_LED_YELLOW).whileTrue( new ledCommand(ledCommand.YELLOW_FLASH));
                                        */
    
    //new JoystickButton(Constants.OiConstants.operatorJoyStick, Constants.OiConstants.INTAKE_POSITION_BUTTON).whileTrue(new IntakePistonCommand(IntakePistonCommand.INTAKE_STATE_CLOSE));
    //new JoystickButton(Constants.OiConstants.operatorJoyStick, Constants.OiConstants.INTAKE_POSITION_BUTTON).whileTrue(new IntakePositionCommand());

    new JoystickButton(Constants.OiConstants.driverJoyStick, 7).onTrue(new BrakeCommand(true));
    new JoystickButton(Constants.OiConstants.driverJoyStick, 8).onTrue(new BrakeCommand(false));

    // XBox Contoller
    new JoystickButton(Constants.OiConstants.driverController, 7).whileTrue(new DriveBrakeMode(true));
    new JoystickButton(Constants.OiConstants.driverController, 8).whileTrue(new DriveBrakeMode(false));


    new JoystickButton(Constants.OiConstants.driverJoyStick, Constants.OiConstants.APRILTAG_TRACK_BUTTON).whileTrue(new AprilTagTrackCommand());  
  
    new JoystickButton(Constants.OiConstants.driverJoyStick, 2).whileTrue(new DriveBrakeMode(true));
    new JoystickButton(Constants.OiConstants.driverJoyStick, 1).whileTrue(new DriveBrakeMode(false));
    new JoystickButton(Constants.OiConstants.driverJoyStick, 3).whileTrue(new GamepieceTrackCommand());

    //new JoystickButton(Constants.OiConstants.driverJoyStick, 12).onTrue(new ExampleCommandGroup());


  }

  /**
   * Use this to pass the autonomous command to the main {@link Robot} class.
   *
   * @return the command to run in autonomous
   */
  public Command getAutonomousCommand() {
    // An example command will be run in autonomous

    return autonomousChooser.getSelected();
    //return Autos.exampleAuto(m_exampleSubsystem);
  }
}
