// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot;

import edu.wpi.first.wpilibj.Joystick;
import edu.wpi.first.math.geometry.Rotation3d;
import edu.wpi.first.math.geometry.Transform3d;
import edu.wpi.first.math.geometry.Translation3d;
import edu.wpi.first.math.kinematics.DifferentialDriveKinematics;
import edu.wpi.first.math.util.Units;
import edu.wpi.first.wpilibj.XboxController;

import static edu.wpi.first.math.util.Units.inchesToMeters;

/**
 * The Constants class provides a convenient place for teams to hold robot-wide numerical or boolean
 * constants. This class should not be used for any other purpose. All constants should be declared
 * globally (i.e. public static). Do not put anything functional in this class.
 *
 * <p>It is advised to statically import this class (or one of its inner classes) wherever the
 * constants are needed, to reduce verbosity.
 */
public final class Constants {

  // TODO - Is this used?
  public static class OperatorConstants {
    public static final int K_DRIVER_CONTROLLER_PORT = 0;
  }

  public static class CANConstants {

    public static final int DRIVE_FR_ID       = 2;
    public static final int DRIVE_FL_ID       = 3;
    public static final int DRIVE_RR_ID       = 4;
    public static final int DRIVE_RL_ID       = 5;
    public static final int STAGE_1_MOTOR_ID  = 6;
    public static final int STAGE_2_MOTOR_ID  = 7;
    public static final int STAGE_3_MOTOR_ID  = 8;
    public static final int STAGE_4_MOTOR_ID  = 9;
    public static final int GYRO_ID           = 10;
    public static final int ROLLER_POS_MOTOR  = 11;
    public static final int INTAKE_POS_MOTOR  = 12;
    public static final int SOLENOID_PCM_ID   = 15;
  }
  
  public static class VisionConstants {
    public static final String MAIN_CAMERA_NAME = "Microsoft_LifeCam_HD-3000 (1)";

     /**
     * Physical location of the camera on the robot, relative to the center of the robot.
     */
    public static final Transform3d CAMERA_TO_ROBOT =
        new Transform3d(new Translation3d(-0.3425, 0.0, -0.233), new Rotation3d());

    public static final Transform3d ROBOT_TO_CAMERA = CAMERA_TO_ROBOT.inverse();

    public static final int VISION_PIPELINE_INDX_APRILTAGS  = 1;
    public static final int VISION_PIPELINE_INDX_CONES      = 2;
  }

  public static class DrivetrainConstants {

    public static final double DRIVETRAIN_TRACKWIDTH_METERS = inchesToMeters(24.5);

    public static final DifferentialDriveKinematics KINEMATICS = new DifferentialDriveKinematics(DRIVETRAIN_TRACKWIDTH_METERS);
    
    public static final double FRONT_CAMERA_HEIGHT_METERS = Units.inchesToMeters(12);
    public static final double REAR_CAMERA_HEIGHT_METERS = Units.inchesToMeters(12);
    public static final double FRONT_CAMERA_PITCH_RADIANS = Units.degreesToRadians(0);
    public static final double REAR_CAMERA_PITCH_RADIANS = Units.degreesToRadians(10);
    public static final double APRILTAG_HEIGHT_METERS = Units.inchesToMeters(16.5);
    public static final double GOAL_RANGE_METERS = Units.inchesToMeters(30);

  }

  public static class OiConstants {
    public static final Joystick driverJoyStick = new Joystick(0);
    public static final Joystick operatorJoyStick = new Joystick(1);
    public static final XboxController driverController = new XboxController(2);

    // Driver joystick buttons
    public static final int APRILTAG_TRACK_BUTTON  = 5;
    public static final int DRIVE_BREAK_ON_BUTTON  = 7;
    public static final int DRIVE_BREAK_OFF_BUTTON = 8;

    public static final int DRIVE_LED_BLUE         = 8;
    public static final int DRIVE_LED_YELLOW       = 7;
    
    // Operator joystick buttons
    public static final int ARM_POSITION_CUBE_HIGH_BUTTON    = 7;
    public static final int ARM_POSITION_CUBE_MID_BUTTON     = 9;
    public static final int ARM_POSITION_CUBE_LOW_BUTTON     = 3;
    public static final int ARM_POSITION_CUBE_FLOOR_BUTTON   = 11;
    
    public static final int ARM_POSITION_CONE_HIGH_BUTTON    = 8;
    public static final int ARM_POSITION_CONE_MID_BUTTON     = 10;
    public static final int ARM_POSITION_CONE_FLOOR_BUTTON   = 12;

    public static final int ARM_POSITION_ZERO_BUTTON         = 6;
    public static final int ARM_POSITION_TERMINAL_BUTTON     = 4;
    public static final int ARM_POSITION_OTT                 = 5;

    public static final int CALIBRATE_PNEUM_OPEN_BUTTON      = 1;
    public static final int CALIBRATE_PNEUM_SHUT_BUTTON      = 2;
    

    public static final int LED = 10;


  }

  public static class NavConstants {
  }

  public static class ArmConstants {
    
    public static final int SOLENOID_FWD_CHAN_ID  = 6;
    public static final int SOLENOID_REV_CHAN_ID  = 7;

    public static int PEAK_VELOCITY_UP = 13360;
    public static final float PERCENT_OF_PEAK_UP = .50f;
    public static final float CRUISE_VELOCITY_ACCEL_UP = PEAK_VELOCITY_UP * PERCENT_OF_PEAK_UP; // 8,684

    public static int PEAK_VELOCITY_DOWN = 13360;
		public static final float PERCENT_OF_PEAK_DOWN = .50f;
		public static final float CRUISE_VELOCITY_ACCEL_DOWN = PEAK_VELOCITY_DOWN * PERCENT_OF_PEAK_DOWN; // 5,258.
  }

  public static class AutoBalanceConstants {

    // Auto Balance
    public static final int AUTONOMOUSE_TIMEOUT_ITERATIONS      = 400;  // ~ 7 seconds
    public static final double CHARGE_STATION_FWD_SPEED         = 0.15;
    public static final double CHARGE_STATION_RVS_SPEED         = -0.1;
    public static final double CHARGE_STATION_TILT_DEG          = 13.0;
    public static final double CHARGE_STATION_PITCH_MOE         = 1;
    public static final long CHARGE_STATION_MIN_TABLE_TIME_MS   = 200;
    public static final int CHARGE_STATION_REVERSE_ITERATIONS   = 10;
    
    // Out and back the balance
    public static final int AUTONOMOUSE_NZ_TIMEOUT_ITERATIONS   = 400;
    public static double MAX_NEUTRAL_ZONE_ENCODER_VALUE         = 1500;

    // Out only
    public static final int AUTO_OUT_ONLY_TIMEOUT_ITERATIONS = 350;

    public static final double NUE_ZONE_RVS_SPEED         = -0.15;
  }
}
