// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.subsystems.vision;

import edu.wpi.first.wpilibj2.command.SubsystemBase;
import frc.robot.Constants;

public class GamePieceFinder extends SubsystemBase {

  private boolean isGamePieceAcquired;
  private GamePiece acquiredGamePiece;

  public GamePieceFinder() {
    isGamePieceAcquired = false;
  }

  @Override
  public void periodic() {
    // Reset search variables for clostest to empty:
    if (LimelightHelpers.hasValidTarget(Constants.VisionConstants.GAMEPIECE_CAMERA_NT_ID)) {
      isGamePieceAcquired = true;

      acquiredGamePiece = new GamePiece();
      acquiredGamePiece.setX(LimelightHelpers.getTX(Constants.VisionConstants.GAMEPIECE_CAMERA_NT_ID));
      acquiredGamePiece.setY(LimelightHelpers.getTY(Constants.VisionConstants.GAMEPIECE_CAMERA_NT_ID));
    }
    else {
      isGamePieceAcquired = false;
    }
  }

  public boolean isGamePieceAcquired() {
    return isGamePieceAcquired;
  }

  public GamePiece getAcquiredGamePiece() {
    return acquiredGamePiece;
  }

  /*
   * 
   */

  public class GamePiece {
    private double x = 0.0;
    private double y = 0.0;

    public void setX(double x) {
      this.x = x;
    }
    public double getX() {
      return this.x;
    }

    public void setY(double y) {
      this.y = y;
    }
    public double getY() {
      return this.y;
    }
  }

}