package frc.robot.subsystems.vision;

import edu.wpi.first.math.geometry.Pose3d;
import edu.wpi.first.wpilibj2.command.SubsystemBase;
import frc.robot.Constants;

public class AprilTagSubsystem extends SubsystemBase {

    private boolean isAprilTagAcquired;
    private double acquiredAprilTagID;
    private Pose3d acquiredAprilTagPose; 
    private double acquiredAprilTagX;
    private double acquiredAprilTagY;

    /*
     * This assumes that the named Limelight is set up to report full 3D data regarding the closest AprilTag
     * AprilTag family for 2024 is  36H11 
     * 
     * From Limelight documentation. Setup camera offset in Limelight browser page Advanced tab
     * LL Forward, LL Right, and LL Up represent distances along the Robot’s forward, right, and up vectors if you were
     * to embody the robot. (in meters). LL Roll, Pitch, and Yaw represent the rotation of your Limelight in degrees. You
     * can modify these values and watch the 3D model of the Limelight change in the 3D viewer. Limelight uses this
     * configuration internally to go from the target pose in camera space -> robot pose in field space.
     * 13.5.
     */
    public AprilTagSubsystem() {
    }

    @Override
    public void periodic() {

      if (LimelightHelpers.hasValidTarget(Constants.VisionConstants.APRILTAG_CAMERA_NT_ID)) {
        this.isAprilTagAcquired = true;

        acquiredAprilTagID = LimelightHelpers.getFiducialID(Constants.VisionConstants.APRILTAG_CAMERA_NT_ID);
        acquiredAprilTagPose = LimelightHelpers.getTargetPose3d_CameraSpace(Constants.VisionConstants.APRILTAG_CAMERA_NT_ID);
        acquiredAprilTagX = LimelightHelpers.getTX(Constants.VisionConstants.APRILTAG_CAMERA_NT_ID);
        acquiredAprilTagY = LimelightHelpers.getTY(Constants.VisionConstants.APRILTAG_CAMERA_NT_ID);
      }
      else {
        this.isAprilTagAcquired = false;
      }
  }

  public boolean isAprilTagAcquired() {

    return isAprilTagAcquired;
  }

  public double getAcquiredAprilTagID() {

    return this.acquiredAprilTagID;
  }

  public Pose3d getAcquiredAprilTagPose() {

    return this.acquiredAprilTagPose;
  }

  public double getAcquiredAprilTagX() {
    return this.acquiredAprilTagX;
  }

  public double getAcquiredAprilTagY() {
    return this.acquiredAprilTagY;
  }
}
