package frc.robot.subsystems;

public class SwerveModuleIDConfig 
{
    private int driveMotorID = 0;
    private int steerMotorID = 0;
    private int steerEncoderID = 0;
    private String canBusName;
    private boolean isMotorReverseDirection;

    SwerveModuleIDConfig() {
    }

    /** Initialize a SwerveModuleIDConfig with drive, steer and encoder CAN ID. */
    SwerveModuleIDConfig(int drive, int steer, int encoder, boolean isMotorReverseDirection) {
        this.driveMotorID = drive;
        this.steerMotorID = steer;
        this.isMotorReverseDirection = isMotorReverseDirection;
        this.steerEncoderID = encoder;
    }
    SwerveModuleIDConfig(int drive, int steer, int encoder, boolean isMotorReverseDirection, String canBusName) {
        this.driveMotorID = drive;
        this.steerMotorID = steer;
        this.steerEncoderID = encoder;
        this.isMotorReverseDirection = isMotorReverseDirection;
        this.canBusName = canBusName;
    }

    public int getDriveMotorID() {
        return this.driveMotorID;
    }
    public int getSteerMotorID() {
        return this.steerMotorID;
    }
    public int getSteerEncoderID() {
        return this.steerEncoderID;
    }
    public boolean isMotorReverseDirection() {
        return this.isMotorReverseDirection;
    }
    public String getCanBusName() {
        return this.canBusName;
    }
}
