// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.subsystems;

import java.util.ResourceBundle.Control;

import com.ctre.phoenix.motorcontrol.ControlMode;
import com.ctre.phoenix.motorcontrol.DemandType;
import com.ctre.phoenix.motorcontrol.NeutralMode;
import com.ctre.phoenix.motorcontrol.RemoteFeedbackDevice;
import com.ctre.phoenix.motorcontrol.TalonFXControlMode;
import com.ctre.phoenix.motorcontrol.TalonFXFeedbackDevice;
import com.ctre.phoenix.motorcontrol.TalonSRXFeedbackDevice;
import com.ctre.phoenix.motorcontrol.can.WPI_TalonFX;
import com.ctre.phoenix.motorcontrol.can.WPI_TalonSRX;
import com.ctre.phoenix.sensors.CANCoder;
import com.ctre.phoenix6.configs.TalonFXConfiguration;
import com.ctre.phoenix6.controls.ControlRequest;
import com.ctre.phoenix6.controls.MotionMagicVoltage;
import com.ctre.phoenix6.controls.PositionVoltage;
import com.ctre.phoenix6.controls.VelocityVoltage;
import com.ctre.phoenix6.hardware.TalonFX;

import edu.wpi.first.math.trajectory.TrapezoidProfile;
import edu.wpi.first.wpilibj.DigitalInput;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.SubsystemBase;
import frc.robot.Constants;

public class Shooter extends SubsystemBase {
  private static TalonFX shooter;
  private static WPI_TalonSRX clocker;
  private static WPI_TalonSRX wrist;
  private static WPI_TalonFX bumperIntake;

  private static CANCoder wrist_encoder;

  private static DigitalInput linebreakSensor;

  public static final double SHOOTER_SHOOTING_SPEED = 0;
  public static final double CLOCKER_SHOOTING_SPEED = 0;
  
  public static final double SHOOTER_INTAKE_SPEED = 0;
  public static final double CLOCKER_INTAKE_SPEED = 0;  
  private final VelocityVoltage m_voltageVelocity;
  private final MotionMagicVoltage m_mmReq;
  private PositionVoltage m_position;
  private TrapezoidProfile m_profile;
  /** Creates a new Shooter. */
  public Shooter() {
    TalonFXConfiguration configs = new TalonFXConfiguration();
    shooter = new TalonFX(Constants.ShooterConstants.SHOOTER_MOTOR_CAN_ID);
    clocker = new WPI_TalonSRX(Constants.ShooterConstants.CLOCKER_MOTOR_CAN_ID);
    wrist = new WPI_TalonSRX(Constants.ShooterConstants.SHOOTER_WRIST_CAN_ID);
    wrist_encoder = new CANCoder(Constants.ShooterConstants.SHOOTER_WRIST_ENCODER_CAN_ID,"rio");
    bumperIntake = new WPI_TalonFX(Constants.BumperIntake.BUMBERINTAKE_MOTOR_ID);
    m_voltageVelocity = new VelocityVoltage(0, 0, true, 0, 0, false, false, false);
    m_mmReq = new MotionMagicVoltage(0);
    m_position = new PositionVoltage(0).withSlot(0);
    m_profile = new TrapezoidProfile(new TrapezoidProfile.Constraints(80, 160));
    linebreakSensor = new DigitalInput(0);
    
    configs.Slot0.kP = 0.11;
    configs.Slot0.kI = 0.5;
    configs.Slot0.kD = 0.0001;
    configs.Slot0.kV = 0.12;

    configs.Slot1.kP = 4.8;
    configs.Slot1.kI = 0;
    configs.Slot1.kD = 0.1;
    configs.Slot1.kV = 0.12;
    configs.Slot1.kS = 0.25;
    shooter.getConfigurator().apply(configs);
    clocker.setNeutralMode(NeutralMode.Brake);



    //shooter.configFactoryDefault();
    //shooter.config_kP(0, 0.1);  // getting there
    //shooter.config_kI(0, 0.001);   // 0.001 D can't quiet get it so adust I to fine tune.
    //shooter.config_kD(0, 5);    // 5overshoot (how much does it come back)
    //shooter.config_kF(0, 0.4/*1023.0/20660.0*/);     // Feed forward - counter act gravity.
    //shooter.configMotionSCurveStrength(3);
    //shooter.configMotionAcceleration(18000,30);//6000,30
    //shooter.configSelectedFeedbackSensor(TalonFXFeedbackDevice.IntegratedSensor,0,0);
    //shooter.configMotionAcceleration(Constants.ArmConstants.CRUISE_VELOCITY_ACCEL_UP, 0);
    //shooter.configMotionCruiseVelocity(Constants.ArmConstants.CRUISE_VELOCITY_ACCEL_UP, 0);
      
    wrist.configFactoryDefault();
    wrist.setNeutralMode(NeutralMode.Brake);
    wrist.config_kP(0, 0.5);  // getting there
    wrist.config_kI(0, 0.0);   // D can't quiet get it so adust I to fine tune.
    wrist.config_kD(0, 0.0);    // overshoot (how much does it come back)
    wrist.config_kF(0, 0.0);     // Feed forward - counter act gravity.
    wrist.configMotionSCurveStrength(3);
    wrist.configMotionAcceleration(6000, 30);
    wrist.configRemoteFeedbackFilter(wrist_encoder,0);
    wrist.configSelectedFeedbackSensor(RemoteFeedbackDevice.RemoteSensor0);
  }
  

  public void scoreInSpeaker(double shooterVelocity, double clockerSpeed) {
    //shooter.set(ControlMode.Velocity,shooterVelocity);
    shooter.set(-0.9);
    if (Math.abs(shooter.getVelocity().getValueAsDouble()) >= 65){
      //shooter.set(ControlMode.Velocity,shooterVelocity);
      clocker.set(ControlMode.PercentOutput,clockerSpeed);
      SmartDashboard.putBoolean("ScoringSpeaker", true);
    }
  }

  public void scoreInSpeakerUsingTime(double shooterVelocity, double clockerSpeed, int time,int timer) {
    //shooter.set(ControlMode.Velocity,shooterVelocity);
    shooter.set(-0.9);
    if (timer > time){
      //shooter.set(ControlMode.Velocity,shooterVelocity);
      clocker.set(ControlMode.PercentOutput,clockerSpeed);
      SmartDashboard.putBoolean("ScoringSpeaker", true);
    }
  }

  // Reposition Note to prepare for shoot
  public void prep(double shooterVelocity, double clockerSpeed) {
    shooter.set(shooterVelocity);
    clocker.set(ControlMode.PercentOutput,clockerSpeed);
    // if (Math.abs(shooter.getSelectedSensorVelocity()) >= Math.abs(shooterVelocity - 100)){
    //   shooter.set(ControlMode.Velocity,shooterVelocity);
    //   clocker.set(ControlMode.PercentOutput, clockerSpeed);
    // }
  } // prep()

  public void kadeCantDriveToSaveHisLife_OMG_BRUH(boolean kadeJustCantRightNow){
    SmartDashboard.putBoolean("SwapIntakeControl", kadeJustCantRightNow);
  }

   public boolean getKadeCantDriveToSaveHisLife_OMG_BRUH(){
    return SmartDashboard.getBoolean("SwapIntakeControl",false);
  }

  public void moveWristMotorToPos(int position) {
    SmartDashboard.putNumber("Wrist - movewristToPos pos: ", position);
    //May be for testing
    wrist.configMotionAcceleration(Constants.ArmConstants.CRUISE_VELOCITY_ACCEL_UP, 0);
    wrist.configMotionCruiseVelocity(Constants.ArmConstants.CRUISE_VELOCITY_ACCEL_UP, 0);
      
    wrist.set(ControlMode.MotionMagic, position);
  }

  public void zeroEncoder(){
    wrist.setSelectedSensorPosition(0);
    wrist_encoder.setPosition(0);
  }

  public double getWristPos(){
    return wrist.getSelectedSensorPosition();
  }

  public void wristSpeedControl(double speed){
    wrist.set(ControlMode.PercentOutput,speed);
  }

  /**
   * 
   * @param mode - set to true for break mode, false for coast
   */
  public void breakMode(boolean mode){
    if(mode){
    wrist.setNeutralMode(NeutralMode.Brake);
    } else {
      wrist.setNeutralMode(NeutralMode.Coast);
    }
  }

  public double getShooterVelocity(){
    return shooter.getVelocity().getValueAsDouble();
  }

  /**
   * 
   * @param clockerSpeed
   * @param shooterSpeed
   */
  public void intake(double clockerSpeed, double shooterSpeed){
    shooter.set(shooterSpeed);
    clocker.set(ControlMode.PercentOutput,clockerSpeed);
  }

/**
 * 
 * @param shooterVelocity - sets the shooter velocity
 * @param clockerSpeed - sets the clocker power
 */

  /*public void shooterVelocityControl(int shooterVelocity, double clockerSpeed ){
    shooter.set(ControlMode.Velocity,shooterVelocity);//shooter.setControl(m_voltageVelocity.withVelocity(shooterVelocity));
    clocker.set(ControlMode.PercentOutput,clockerSpeed);
  }*/

  /*public void moveShooterToPOS(int pos){
    shooter.setControl(m_position.withPosition(pos));
  }*/
//dData
  public void printShooterData(){
    SmartDashboard.putNumber("WristEncoder", wrist_encoder.getPosition());
    SmartDashboard.putNumber("WristEncoderFromMotorPID", wrist.getSelectedSensorPosition());
    SmartDashboard.putNumber("Shooter_Wheel_Velocity", shooter.getVelocity().getValueAsDouble());
    //SmartDashboard.putNumber("ShooterPOS", shooter.getPosition().getValueAsDouble());
    SmartDashboard.putBoolean("LinebreakSensor", getLineBreak());
    SmartDashboard.putBoolean("LoadedGamePiece", !getLineBreak());
    SmartDashboard.putNumber("Wrist Amps", wrist.getBusVoltage());
    
  }

  public double getWristAmps(){
    return wrist.getStatorCurrent();
  }

  public void moveClocker(double power){
    clocker.set(power);
  }

  public void moveBumperIntake(double power){
    bumperIntake.set(ControlMode.PercentOutput, power);
  }

  public boolean getLineBreak(){
    return linebreakSensor.get();
  }

  @Override
  public void periodic() {
    // This method will be called once per scheduler run
  }
}