// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.subsystems;

import com.ctre.phoenix.motorcontrol.ControlMode;
import com.ctre.phoenix.motorcontrol.NeutralMode;
import com.ctre.phoenix.motorcontrol.TalonFXFeedbackDevice;
import com.ctre.phoenix.motorcontrol.TalonSRXFeedbackDevice;
import com.ctre.phoenix.motorcontrol.can.WPI_TalonSRX;

import edu.wpi.first.wpilibj.Servo;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.SubsystemBase;
import frc.robot.Constants;

public class Climber extends SubsystemBase {
  private static WPI_TalonSRX LeftClimbMotor;
  private static WPI_TalonSRX RightClimbMotor;
  private static WPI_TalonSRX ClimberWheels;
  private static Servo climberReleaseServo;

  /** Creates a new Climber. */
  public Climber() {
    ClimberWheels = new WPI_TalonSRX(Constants.ClimberConstants.CLIMBER_WHEELS_CAN_ID);
    LeftClimbMotor = new WPI_TalonSRX(Constants.ClimberConstants.CLIMBER_1_CAN_ID);
    RightClimbMotor = new WPI_TalonSRX(Constants.ClimberConstants.CLIMBER_2_CAN_ID);
    climberReleaseServo = new Servo(1);

    LeftClimbMotor.config_kP(0, 0.1);  // getting there
    LeftClimbMotor.config_kI(0, 0.0);   // D can't quiet get it so adust I to fine tune.
    LeftClimbMotor.config_kD(0, 0);    // overshoot (how much does it come back)
    LeftClimbMotor.config_kF(0, 0.0);     // Feed forward - counter act gravity.
    LeftClimbMotor.configMotionSCurveStrength(3);
    LeftClimbMotor.configMotionAcceleration(6000, 30);
    LeftClimbMotor.setInverted(true);
    LeftClimbMotor.setNeutralMode(NeutralMode.Brake);

    //LeftClimbMotor.configSelectedFeedbackSensor(TalonSRXFeedbackDevice.QuadEncoder,0,0);
    LeftClimbMotor.follow(RightClimbMotor);

    RightClimbMotor.config_kP(0, 0.1);
    RightClimbMotor.config_kI(0, 0.0);
    RightClimbMotor.config_kD(0, 0);
    RightClimbMotor.config_kF(0, 0);
    RightClimbMotor.configMotionSCurveStrength(3);
    RightClimbMotor.configMotionAcceleration(6000, 30);
    RightClimbMotor.setInverted(false);
    RightClimbMotor.setSensorPhase(false);
    RightClimbMotor.configSelectedFeedbackSensor(TalonSRXFeedbackDevice.QuadEncoder,0,0);
    RightClimbMotor.setNeutralMode(NeutralMode.Brake);
    
  }

  public void moveRightClimbMotorToPos(int position) {
    SmartDashboard.putNumber("Arm - moveLeftClimbMotorToPos pos: ", position);

    RightClimbMotor.configMotionAcceleration(Constants.ArmConstants.CRUISE_VELOCITY_ACCEL_UP, 0);
    RightClimbMotor.configMotionCruiseVelocity(Constants.ArmConstants.CRUISE_VELOCITY_ACCEL_UP, 0);
    RightClimbMotor.set(ControlMode.MotionMagic, position);
  }

  public double getLeftClimbMotorPos(){
    return LeftClimbMotor.getSelectedSensorPosition();
  }

  //Right encoder works 0 all the way down, -30097  all the way up
  public double getRightClimbMotorPos(){
    return RightClimbMotor.getSelectedSensorPosition();
  }

  public void moveClimberUsingPower(double power){
    //LeftClimbMotor.set(power);
    RightClimbMotor.set(power);
  }

  public void printClimberEncoders(){
    SmartDashboard.putNumber("LeftClimberEncoder", getLeftClimbMotorPos());
    SmartDashboard.putNumber("RightClimberEncoder", getRightClimbMotorPos());
  }

  public void zeroEncoder(){
    RightClimbMotor.setSelectedSensorPosition(0);
    LeftClimbMotor.setSelectedSensorPosition(0);
  }

  public void moveClimberWheels(double power){
    ClimberWheels.set(ControlMode.PercentOutput, power);
  }

  public void servoControl(int angle) {
    climberReleaseServo.setAngle(angle);
    
  }
  public void resetClimberRelease() {
    climberReleaseServo.set(0);
    SmartDashboard.putBoolean("Servo Released", false);
    SmartDashboard.updateValues();
  }

  @Override
  public void periodic() {
    // This method will be called once per scheduler run
  }
}
