// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.subsystems;

import com.ctre.phoenix.motorcontrol.ControlMode;
import com.ctre.phoenix.motorcontrol.NeutralMode;
import com.ctre.phoenix.motorcontrol.RemoteFeedbackDevice;
import com.ctre.phoenix.motorcontrol.can.WPI_TalonFX;
import com.ctre.phoenix.motorcontrol.can.WPI_TalonSRX;
import com.ctre.phoenix.sensors.CANCoder;

import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.SubsystemBase;
import frc.robot.Constants;

public class Arm extends SubsystemBase {
  /** Creates a new Arm. */
  private static WPI_TalonFX ArmMotor;
  private static CANCoder ArmEncoder;

  public Arm() {
    ArmMotor = new WPI_TalonFX(Constants.ArmConstants.ARM_MOTOR_CAN_ID);
    ArmEncoder = new CANCoder(Constants.ArmConstants.ARM_ENCODER_CAN_ID);

    /**Set up arm motor */
    ArmMotor.configFactoryDefault();
    ArmMotor.setNeutralMode(NeutralMode.Brake);
    /**Set up PID */
    ArmMotor.config_kP(0, 1.6);  // getting there 1.6
    ArmMotor.config_kI(0, 0.0002); //0.00008  // D can't quiet get it so adust I to fine tune.
    ArmMotor.config_kD(0, 0.0);    // overshoot (how much does it come back)
    ArmMotor.config_kF(0, 0.0);     // Feed forward - counter act gravity.
    ArmMotor.configMotionSCurveStrength(3);
    ArmMotor.configMotionAcceleration(150, 30); //6000
    ArmMotor.configMotionCruiseVelocity(2500, 30);
    /**Set up encoder */
    ArmMotor.configRemoteFeedbackFilter(ArmEncoder, 0);
    ArmMotor.configSelectedFeedbackSensor(RemoteFeedbackDevice.RemoteSensor0);
    ArmMotor.setSensorPhase(true);
    
  }
  public void moveArmMotorToPos(int position) {
    SmartDashboard.putNumber("Arm - moveArmMotorToPos pos: ", position);

    //These may be for testing
    //ArmMotor.configMotionAcceleration(Constants.ArmConstants.CRUISE_VELOCITY_ACCEL_UP, 0);

    ArmMotor.set(ControlMode.MotionMagic, position);
  }

  public void zeroEncoder(){
    ArmMotor.setSelectedSensorPosition(0);
    ArmEncoder.setPosition(0);
  }

  public void armSpeedControl(double speed){
    ArmMotor.set(ControlMode.PercentOutput,speed);
  }

  public double getArmMotorPos(){
    return ArmMotor.getSelectedSensorPosition();
  }

  /**
   * 
   * @param mode - set to true for break mode, false for coast
   */
  public void breakMode(boolean mode){
    if(mode){
    ArmMotor.setNeutralMode(NeutralMode.Brake);
    } else {
      ArmMotor.setNeutralMode(NeutralMode.Coast);
    }
  }

  public void printArmData(){
    SmartDashboard.putNumber("ArmEncoderFromMotorForPID", ArmMotor.getSelectedSensorPosition());
    SmartDashboard.putNumber("ArmEncoderRAW", ArmEncoder.getAbsolutePosition());
  }

  @Override
  public void periodic() {
    // This method will be called once per scheduler run
  }
  
}
