// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands.manualControlCommands;

import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.Command;
import frc.robot.RobotContainer;

public class ManualWristControl extends Command {
  int position;
  String ModeSelection;
  /** Creates a new WristControl. */
  public ManualWristControl(int position) {
    addRequirements(RobotContainer.m_shooter);
    // Use addRequirements() here to declare subsystem dependencies.
    position = this.position;
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {
    //RobotContainer.m_shooter.zeroEncoder();
    //RobotContainer.m_shooter.moveWristMotorToPos(position);
    
    ModeSelection = RobotContainer.m_TestChooser.getSelected();
    SmartDashboard.putBoolean("RunningWristControl", true);
  }

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {

    switch(ModeSelection){
      case "test":
      RobotContainer.m_shooter.printShooterData();
      RobotContainer.m_shooter.wristSpeedControl(RobotContainer.m_OI.getDriverLeftY());

      //negative power is fold on to the top of the bot
      //positive power is fold out to pick up

        // code block
        break;
      case "competition":
        
        // code block
        break;
      default:
        // code block
    }

  }

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {
    SmartDashboard.putBoolean("RunningWristControl", false);
  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {
    if(ModeSelection == "competition"){
      return true;
    } else {
      return false;
    }
  }
  
}
