// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands.manualControlCommands;

import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.Command;
import frc.robot.RobotContainer;

public class ManualShooterControl extends Command {
  String ModeSelection;
  int angle;
  double shooterSpeed;
  double clockerSpeed;
  /** Creates a new ShooterControl. */
  public ManualShooterControl(double shooterSpeed, double clockerSpeed) {
    // Use addRequirements() here to declare subsystem dependencies.
    shooterSpeed = this.shooterSpeed;
    clockerSpeed = this.clockerSpeed;
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {
    ModeSelection = RobotContainer.m_TestChooser.getSelected();
    angle = 0;
  }

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {
    switch(ModeSelection){
    case "test":
      RobotContainer.m_shooter.intake(RobotContainer.m_OI.getDriverLeftY(),RobotContainer.m_OI.getDriverRightY());
      SmartDashboard.putNumber("ShooterDirection", RobotContainer.m_OI.getDriverRightY());
      SmartDashboard.putNumber("ClockerDirection", RobotContainer.m_OI.getDriverLeftY());

      //Shooter -negative speed is shoot, + is intake
      //Clocker -negative speed is shoot, + is intake

      if(RobotContainer.m_OI.getAButton()){
          angle += angle;
      }

      if(RobotContainer.m_OI.getBButton()){
          angle -= angle;   
      }
      RobotContainer.m_shooter.printShooterData();
      //RobotContainer.m_shooter.moveWristMotorToPos(angle);
      // code block
      break;
    case "competition":
      
      // code block
      break;
    default:
      // code block
  }
}

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {
    RobotContainer.m_shooter.intake(0,0);
  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {
    return false;
  }
}
