// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands.manualControlCommands;

import edu.wpi.first.wpilibj2.command.Command;
import frc.robot.RobotContainer;

public class ManualClimberControl extends Command {
  double power;
  double speed;
  double y;
  /** Creates a new ManualClimberControl. */
  public ManualClimberControl(double power) {
    // Use addRequirements() here to declare subsystem dependencies.
    addRequirements(RobotContainer.m_climber);
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {
    RobotContainer.m_climber.moveClimberUsingPower(0);
    RobotContainer.m_arm.breakMode(false);
    RobotContainer.m_climber.servoControl(100);
    power = 0;
  }

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {
    y = RobotContainer.m_OI.getOperatorLeftY();
    if(RobotContainer.m_arm.getArmMotorPos() < 50 || y < 0){
      speed = 0;
    } else {
      speed = y;
    }
    RobotContainer.m_climber.moveClimberUsingPower(speed);
    //RobotContainer.m_climber.moveClimberWheels(RobotContainer.m_OI.getOperatorLeftY());
  }

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {
        RobotContainer.m_climber.moveClimberUsingPower(0);
        RobotContainer.m_climber.moveClimberWheels(0);
        RobotContainer.m_climber.servoControl(50);

        //TODO comment out break mode if using middle lift
        RobotContainer.m_arm.breakMode(true);

  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {
    return false;
  }
}
