// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands.manualControlCommands;

import edu.wpi.first.wpilibj2.command.Command;
import frc.robot.RobotContainer;
import frc.robot.subsystems.OI;

public class ManualArmControl extends Command {
  String ModeSelection;
  int position;
  double speed;
  /** Creates a new ArmControl. */
  public ManualArmControl() {
    // Use addRequirements() here to declare subsystem dependencies.
    position = this.position;
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {
    //RobotContainer.m_arm.zeroEncoder();

    RobotContainer.m_arm.armSpeedControl(0);
    speed = 0;

  }

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {
    if((RobotContainer.m_arm.getArmMotorPos() >= 1000 && RobotContainer.m_OI.getOperatorRightY() < 0) || (RobotContainer.m_arm.getArmMotorPos() < 0 && RobotContainer.m_OI.getOperatorRightY() > 0)){
      speed = 0;
    } else {
      speed = -RobotContainer.m_OI.getOperatorRightY();
    }

    if(RobotContainer.m_arm.getArmMotorPos() > 200){
      RobotContainer.m_shooter.moveWristMotorToPos(3600);
    } else {
            RobotContainer.m_shooter.moveWristMotorToPos(1603);
    }
    RobotContainer.m_arm.armSpeedControl(speed);
      

  }

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {
    RobotContainer.m_arm.armSpeedControl(0);
    int pos = (int)RobotContainer.m_arm.getArmMotorPos();
    RobotContainer.m_arm.moveArmMotorToPos(pos);

  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {
    return false;
  }
}



