// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands;

import javax.swing.text.html.HTML.Tag;

import com.ctre.phoenix6.mechanisms.swerve.SwerveRequest.RobotCentric;

import edu.wpi.first.math.kinematics.ChassisSpeeds;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.Command;
import frc.robot.Constants;
import frc.robot.RobotContainer;
import frc.robot.subsystems.CommandSwerveDrivetrain;
import frc.robot.subsystems.Shooter;
import frc.robot.subsystems.vision.AprilTagSubsystem;

public class ScoreSpeakerKadThinksHesSmart extends Command {
  /** Creates a new ScoreSpeaker. */
  double shooterVelocity;
  double clockerPower;
  boolean initialState;
  int timer;
  private CommandSwerveDrivetrain drivetrain;
  private ChassisSpeeds chassisSpeeds;
  private int tag;

  private AprilTagSubsystem finder;
  public ScoreSpeakerKadThinksHesSmart() {
    addRequirements(RobotContainer.m_shooter);
    this.drivetrain = RobotContainer.drivetrain;
    this.finder = RobotContainer.m_aprilTagSubsystem;
    // Use addRequirements() here to declare subsystem dependencies.
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {
    initialState = RobotContainer.m_shooter.getLineBreak();
    SmartDashboard.putBoolean("ScoringSpeaker", false);
    //RobotContainer.m_shooter.moveWristMotorToPos(580);
    tag = (int)SmartDashboard.getNumber("AprilTagWeWant", 98);

    shooterVelocity = -0.9;
    clockerPower = -1;
    timer = 0;
  }

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {
      

    if (!finder.isAprilTagAcquired() || finder.getAcquiredAprilTagID() != tag) {
      return;
   }

      RobotContainer.m_lightControl.setBlinkinColor(0.15);
      double TagY = finder.getAcquiredAprilTagY(); //0.04306 //11.68518 //1190.543646
      RobotContainer.m_shooter.moveWristMotorToPos((int)(0.04306 * TagY * TagY + 12.00518 * TagY + 1220.543646));
      RobotContainer.m_shooter.scoreInSpeaker(shooterVelocity, clockerPower);
      
      double acquiredAprilTagX = finder.getAcquiredAprilTagX();
      double speedControl = 1.0 / 30.0;
      double rotateVal = speedControl * acquiredAprilTagX;
      rotateVal =  rotateVal * 3;
  
      chassisSpeeds = new ChassisSpeeds(0, 0, -rotateVal);
      drivetrain.driveWithChassisSpeeds(chassisSpeeds);
      timer = timer + 1;
  }

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {
    RobotContainer.m_shooter.intake(0,0);
    RobotContainer.m_shooter.moveWristMotorToPos(1609);
    RobotContainer.m_lightControl.setBlinkinColor(SmartDashboard.getNumber("AllianceCollorNumber", 0.86));


  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {

    if(RobotContainer.m_shooter.getLineBreak() != initialState){
      return true;
    } else {
      return false;
    }

    //return false;
  }
}
