// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands;

import edu.wpi.first.wpilibj2.command.Command;
import frc.robot.Constants;
import frc.robot.RobotContainer;

public class ReturnFromAmp extends Command {
  int timer;
  int currentTime;
  double power;
  /** Creates a new RunClockersForTime. */
  public ReturnFromAmp() {
    // Use addRequirements() here to declare subsystem dependencies.
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {
    currentTime = 0;
    timer = 50;
    power = 0.7;
  }

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {
    RobotContainer.m_shooter.intake(-0.4, -0.2);
    if(timer > 30){
      RobotContainer.m_arm.moveArmMotorToPos(670);
      RobotContainer.m_shooter.moveWristMotorToPos(2628);
    }
    currentTime = currentTime + 1;
  }

  // Called once the command ends or is interrupted. 2628
  @Override
  public void end(boolean interrupted) {
    RobotContainer.m_shooter.intake(0,0);
    RobotContainer.m_arm.moveArmMotorToPos(0);
    RobotContainer.m_shooter.moveWristMotorToPos(Constants.ShooterConstants.BASE_WRIST_POS);
  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {
    if(timer > currentTime){
      return false;
    } else {
      return true;
    }
  }
}
