// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands;

import edu.wpi.first.wpilibj2.command.Command;
import frc.robot.RobotContainer;

public class ResetWristZero extends Command {
  double starting_Time;
  double amps;

  /** Creates a new ResetWristZero. */
  public ResetWristZero() {
    // Use addRequirements() here to declare subsystem dependencies.
  }
  // Called when the command is initially scheduled.
  @Override
  public void initialize() {
    starting_Time = System.currentTimeMillis();
  }

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {
    if(starting_Time - System.currentTimeMillis() <= 400){
      amps = RobotContainer.m_shooter.getWristAmps();
    }
    RobotContainer.m_shooter.wristSpeedControl(-0.1);
  }

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {
    RobotContainer.m_shooter.wristSpeedControl(0);
    //RobotContainer.m_shooter.moveWristMotorToPos(0);
  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {
    if(starting_Time - System.currentTimeMillis() <= 400){
      if(amps < amps + 1){
        RobotContainer.m_shooter.zeroEncoder();
        return true;
      }
    return false;
    }
    return false;
  }
}
