// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands;

import com.ctre.phoenix6.mechanisms.swerve.SwerveRequest.RobotCentric;

import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.Command;
import frc.robot.Constants;
import frc.robot.RobotContainer;
import frc.robot.subsystems.Shooter;

public class PassNote extends Command {
  /** Creates a new ScoreSpeaker. */
  double shooterVelocity;
  double clockerPower;
  boolean initialState;
  int timer;
  public PassNote() {
    addRequirements(RobotContainer.m_shooter);
    // Use addRequirements() here to declare subsystem dependencies.
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {
    initialState = RobotContainer.m_shooter.getLineBreak();
    SmartDashboard.putBoolean("ScoringSpeaker", false);
    //RobotContainer.m_shooter.moveWristMotorToPos(580);

    shooterVelocity = -1;
    clockerPower = -1;
    timer = 0;
  }

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {
    
    //RobotContainer.m_shooter.scoreInSpeaker(shooterVelocity, clockerPower);
    if(timer < 50){
          RobotContainer.m_shooter.intake(0, shooterVelocity);
    } else {
         RobotContainer.m_shooter.intake(clockerPower, shooterVelocity);

    }
    RobotContainer.m_shooter.moveWristMotorToPos((int) 1200);    //SmartDashboard.getNumber("IsetTheWristPOS",0));//1300
    

    timer = timer + 1;
  }

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {
    RobotContainer.m_shooter.intake(0,0);
    RobotContainer.m_shooter.moveWristMotorToPos(1609);

  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {

    if( timer > 60){
      return true;
    } else {
      return false;
    }

    //return false;
  }
}
