// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands;

import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.Command;
import frc.robot.RobotContainer;
import frc.robot.subsystems.vision.LimelightHelpers;

public class FlashLights extends Command {
  int timer;
  int time;
  /** Creates a new FlashLights. */
  public FlashLights(int time) {
    this.time = time;
    // Use addRequirements() here to declare subsystem dependencies.
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {
    timer = 0;
  }

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {
    LimelightHelpers.setLEDMode_ForceBlink("limelight-gpiece");
    LimelightHelpers.setLEDMode_ForceBlink("limelight-front");
    RobotContainer.m_lightControl.setBlinkinColor(-0.61);
    timer = timer + 1;
  }

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {
    LimelightHelpers.setLEDMode_ForceOff("limelight-gpiece");
    LimelightHelpers.setLEDMode_ForceOff("limelight-front");
    RobotContainer.m_lightControl.setBlinkinColor(SmartDashboard.getNumber("AllianceCollorNumber", 0.86));

  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {
    if(timer > time){
      return true;
    } else {
      return false;
    }
  }
}
