// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands;

import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.Command;
import frc.robot.RobotContainer;

public class ControlClockerForTime extends Command {
  
  int errorAcceptance = 20;
  int shooterVelocity;
  double clockerPower;
  double shooterPower;
  int time;
  int timer;

  /**
   * Prep note for shooting
   * @param shooterVelocity
   * @param clockerPower
   */
  public ControlClockerForTime(double clockerPower, double shooterPower, int time) {
    // Use addRequirements() here to declare subsystem dependencies.
    addRequirements(RobotContainer.m_shooter);
    this.time = time;
    this.shooterPower = shooterPower;
    this.clockerPower = clockerPower;
    
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {
    timer = 0;
    SmartDashboard.putBoolean("RunningControlIntakeCommand",true);

  }

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {
    //if(shooterVelocity < 0){
      //RobotContainer.m_shooter.moveClocker(clockerPower);
      RobotContainer.m_shooter.intake(clockerPower,shooterPower);
    //} else {
       //RobotContainer.m_shooter.shooterVelocityControl(shooterVelocity,clockerPower);
    //}
      timer = timer + 1;
  }

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {
    SmartDashboard.putBoolean("RunningControlIntakeCommand",false);
    RobotContainer.m_shooter.intake(0,0);
  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {
if(timer > time){
      return true;
    } else {
      return false;
    }
  }
}
