// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands;

import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.Command;
import frc.robot.RobotContainer;
import frc.robot.subsystems.OI;

public class ControlClimber extends Command {
  int targetPosition;
  int errorAcceptance = 20;

  /** Creates a new ClimberControl. */
  public ControlClimber(int targetPosition) {
    // Use addRequirements() here to declare subsystem dependencies.
    this.targetPosition = targetPosition;
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {
    SmartDashboard.putBoolean("RunningControlClimberCommand",true);

  }

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {
    //RobotContainer.m_climber.moveRightClimbMotorToPos(targetPosition);
    RobotContainer.m_climber.moveRightClimbMotorToPos(targetPosition);
  }

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {
    SmartDashboard.putBoolean("RunningControlArmCommand",false);
    RobotContainer.m_climber.resetClimberRelease();

  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {

    double actualPosition = Math.abs(RobotContainer.m_climber.getRightClimbMotorPos());
    double absTargetPosition = Math.abs(targetPosition);
    boolean isWithinTargetRange = actualPosition > (absTargetPosition - errorAcceptance) && 
    actualPosition < (absTargetPosition + errorAcceptance);

    return isWithinTargetRange;
  }
}
