// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands;

import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.Command;
import frc.robot.RobotContainer;

public class ControlBumpererIntake extends Command {
  double speed;
  int errorAcceptance = 20;

  /** Creates a new ArmControl. */
  public ControlBumpererIntake(double speed) {
    // Use addRequirements() here to declare subsystem dependencies.
    //addRequirements(RobotContainer.m_shooter);
    //325 angle speaker shot
    //4326 for amp + arm up pos
    this.speed = speed;
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {
    SmartDashboard.putBoolean("RunningControlBumperCommand",true);

  }

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {
    RobotContainer.m_shooter.moveBumperIntake(speed);
  }

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {
    SmartDashboard.putBoolean("RunningControlBumperCommand",false);
    RobotContainer.m_shooter.moveBumperIntake(0);
  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {
    return false;
  }
}
