// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands;

import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.Command;
import frc.robot.Constants;
import frc.robot.RobotContainer;

public class CollectFromFloor extends Command {
  /** Creates a new CollectFromFloor. */
  public CollectFromFloor() {
    // Use addRequirements() here to declare subsystem dependencies.
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {
    //RobotContainer.m_.setBlinkinColor(-0.01);
  }

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {
    if(RobotContainer.m_arm.getArmMotorPos() > 100){
      return;
    }

    RobotContainer.m_shooter.moveBumperIntake(0.80);
    RobotContainer.m_shooter.moveClocker(-0.25);
    RobotContainer.m_shooter.moveWristMotorToPos(Constants.ShooterConstants.BASE_WRIST_POS);
    RobotContainer.m_lightControl.setBlinkinColor(0.57);
  }

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {
      RobotContainer.m_shooter.moveBumperIntake(0);
      RobotContainer.m_shooter.moveClocker(0);
      RobotContainer.m_lightControl.setBlinkinColor(SmartDashboard.getNumber("AllianceCollorNumber", 0.86));

  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {
    if(!RobotContainer.m_shooter.getLineBreak()){
      new FlashLights(30).schedule();
      return true;
    } else {
      return false;
    }
    
  }
}
