// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands;

import edu.wpi.first.wpilibj2.command.Command;
import frc.robot.RobotContainer;

public class Climb_Prep extends Command {
  /** Creates a new Climb_Prep. */
  public Climb_Prep() {
    // Use addRequirements() here to declare subsystem dependencies.
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {
    RobotContainer.m_climber.servoControl(100);
  }

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {
    RobotContainer.m_lightControl.setBlinkinColor(-0.43);
    RobotContainer.m_arm.moveArmMotorToPos(870);
    if(RobotContainer.m_arm.getArmMotorPos() > 200){
      RobotContainer.m_shooter.moveWristMotorToPos(3600);
    } else {
            RobotContainer.m_shooter.moveWristMotorToPos(1603);
    }

  }

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {
        RobotContainer.m_climber.servoControl(60);

  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {
    if(RobotContainer.m_arm.getArmMotorPos() > 400){
      return true;
    } else {
      return false;
    }
  }
}
