// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands;

import edu.wpi.first.wpilibj2.command.Command;
import frc.robot.RobotContainer;

public class Climb_Hang extends Command {
  /** Creates a new Climb_Hang. */
  public Climb_Hang() {
    // Use addRequirements() here to declare subsystem dependencies.
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {
      RobotContainer.m_arm.breakMode(false);
  }

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {
    RobotContainer.m_arm.armSpeedControl(0);
    RobotContainer.m_climber.moveClimberUsingPower(-0.3);
    if(RobotContainer.m_arm.getArmMotorPos() < 380){
      RobotContainer.m_shooter.moveWristMotorToPos(1603);
    } 

    
  }

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {
          RobotContainer.m_arm.breakMode(true);
          RobotContainer.m_climber.moveClimberUsingPower(0);

  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {
    if(RobotContainer.m_arm.getArmMotorPos() > 200){
        return false;
    } else {
      return true;
    }
  }
}
