// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands;

import com.ctre.phoenix6.mechanisms.swerve.SwerveModule.DriveRequestType;
import com.ctre.phoenix6.mechanisms.swerve.SwerveRequest;

import edu.wpi.first.math.kinematics.ChassisSpeeds;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.Command;
import frc.robot.RobotContainer;
import frc.robot.TunerConstants;
import frc.robot.subsystems.CommandSwerveDrivetrain;
import frc.robot.subsystems.DriveSubsystem;
import frc.robot.subsystems.vision.GamePieceFinder;
import frc.robot.subsystems.vision.GamePieceFinder.GamePiece;

public class AlignToGamePiece extends Command {
  private CommandSwerveDrivetrain drivetrain;
  private GamePieceFinder finder;
  private ChassisSpeeds chassisSpeeds;
  private double MaxSpeed = TunerConstants.kSpeedAt12VoltsMps; // kSpeedAt12VoltsMps desired top speed
  private double MaxAngularRate = 1.5 * Math.PI; // 3/4 of a rotation per second max angular velocity
  private final SwerveRequest.RobotCentric driveRobotCentric = new SwerveRequest.RobotCentric().withDriveRequestType(DriveRequestType.OpenLoopVoltage);
  private final SwerveRequest.FieldCentric drive = new SwerveRequest.FieldCentric();
  private final SwerveRequest.FieldCentric fieldCentric = new SwerveRequest.FieldCentric().withDriveRequestType(DriveRequestType.OpenLoopVoltage);                                                         // driving in open loop

  public AlignToGamePiece() {
    // Use addRequirements() here to declare subsystem dependencies.
    this.drivetrain = RobotContainer.drivetrain;;
    this.finder = RobotContainer.m_gamePieceFinder;
    //addRequirements(drivetrain);
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {
  }

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {
    
    if (!finder.isGamePieceAcquired()) {
        RobotContainer.m_lightControl.setBlinkinColor(SmartDashboard.getNumber("AllianceCollorNumber", 0.86));
      return;
    } else {
      
      RobotContainer.m_lightControl.setBlinkinColor(0.65);
      GamePiece gamePiece = finder.getAcquiredGamePiece();

    double speedControl = 1.0 / 30.0;
    double rotateVal = (speedControl * -gamePiece.getX());
   // rotateVal = rotateVal * 2;

    chassisSpeeds = new ChassisSpeeds(RobotContainer.m_OI.getDriverLeftY(), RobotContainer.m_OI.getDriverLeftX(), rotateVal);
    //drivetrain.applyRequest(() -> fieldCentric.withVelocityX(-RobotContainer.m_OI.getDriverLeftY()).withVelocityY(RobotContainer.m_OI.getDriverLeftX()).withRotationalRate(rotateVal*4)); 
    drivetrain.driveWithChassisSpeeds(chassisSpeeds);
    
    
    }

    
  }

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {
    RobotContainer.m_lightControl.setBlinkinColor(SmartDashboard.getNumber("AllianceCollorNumber", 0.86));
    //drivetrain.setAutoOverrideChassisSpeeds(null);
  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {
      return false;
  }
}