// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands;

import edu.wpi.first.math.geometry.Pose3d;
import edu.wpi.first.math.kinematics.ChassisSpeeds;
import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.Command;
import frc.robot.RobotContainer;
import frc.robot.subsystems.CommandSwerveDrivetrain;
import frc.robot.subsystems.DriveSubsystem;
import frc.robot.subsystems.vision.AprilTagSubsystem;

public class AlignToAprilTag extends Command {

  private CommandSwerveDrivetrain drivetrain;
  private AprilTagSubsystem finder;
  private ChassisSpeeds chassisSpeeds;
  private int tag;

  public AlignToAprilTag() {
    this.drivetrain = RobotContainer.drivetrain;
    this.finder = RobotContainer.m_aprilTagSubsystem;
    //addRequirements(drivetrain);
  }

  @Override
  public void initialize() {
    tag = (int)SmartDashboard.getNumber("AprilTagWeWant", 98);
  }

  @Override
  public void execute() {
    
    if (!finder.isAprilTagAcquired() || finder.getAcquiredAprilTagID() != tag) {
       return;
    }
    RobotContainer.m_lightControl.setBlinkinColor(0.57);
    //tag 4 is red speaker, tag 7 is blue
    //Pose3d aTagPose3D = finder.getAcquiredAprilTagPose();
    double acquiredAprilTagX = finder.getAcquiredAprilTagX();
    double acquiredAprilTagY = finder.getAcquiredAprilTagY();

    double speedControl = 1.0 / 30.0;
    double rotateVal = speedControl * acquiredAprilTagX;
    rotateVal =  rotateVal * 3;

     double verticalSpeed = speedControl * -acquiredAprilTagY;
     verticalSpeed =  verticalSpeed * 4;

     //TODO test if we need to reverse the direction when going for the april tag
    chassisSpeeds = new ChassisSpeeds(-verticalSpeed, 0, -rotateVal);
    drivetrain.driveWithChassisSpeeds(chassisSpeeds);
    //DriverStation.getMatchTime();
    //RobotContainer.m_OI.setBlinkinColor();
    //drivetrain.setAutoOverrideChassisSpeeds(chassisSpeeds);
  }

  // Called once the command ends or is interrupted.
  /**
   * Stops the robot
   * Clears all of the LEDs
   */
  @Override
  public void end(boolean interrupted) {
    RobotContainer.m_lightControl.setBlinkinColor(SmartDashboard.getNumber("AllianceCollorNumber", 0.86));

    //drivetrain.setAutoOverrideChassisSpeeds(null);
  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {
    return false;
  }
}