// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot;

import com.ctre.phoenix6.mechanisms.swerve.SwerveModule.DriveRequestType;
import com.ctre.phoenix6.mechanisms.swerve.SwerveRequest;
import com.pathplanner.lib.auto.AutoBuilder;
import com.pathplanner.lib.auto.NamedCommands;
import com.pathplanner.lib.commands.PathPlannerAuto;

import edu.wpi.first.math.geometry.Rotation2d;
import edu.wpi.first.wpilibj.smartdashboard.SendableChooser;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.Command;
import edu.wpi.first.wpilibj2.command.CommandScheduler;
import edu.wpi.first.wpilibj2.command.Commands;
import edu.wpi.first.wpilibj2.command.SequentialCommandGroup;
import edu.wpi.first.wpilibj2.command.button.CommandXboxController;
import edu.wpi.first.wpilibj2.command.button.JoystickButton;
import frc.robot.commands.AlignToAprilTag;
import frc.robot.commands.AlignToGamePiece;
import frc.robot.commands.Climb_Hang;
import frc.robot.commands.Climb_Prep;
import frc.robot.commands.ClimberServoControl;
import frc.robot.commands.ClimberServoControlManual;
import frc.robot.commands.CollectFromFloor;
import frc.robot.commands.ControlArm;
import frc.robot.commands.ControlBumpererIntake;
import frc.robot.commands.ControlClimber;
import frc.robot.commands.ControlClockerForTime;
import frc.robot.commands.ControlWrist;
import frc.robot.commands.DemoKidPass;
import frc.robot.commands.DriveToPoint;
import frc.robot.commands.LowerArmFromAmp;
import frc.robot.commands.NoteFeedThrough;
import frc.robot.commands.PassNote;
import frc.robot.commands.ResetClimber;
import frc.robot.commands.ResetWristZero;
import frc.robot.commands.ShooterCommand;
import frc.robot.commands.TeleopDrive;
import frc.robot.commands.TimerCommand;
import frc.robot.commands.ScoreAmp;
import frc.robot.commands.ScoreSpeaker;
import frc.robot.commands.ScoreSpeakerAutoInitial;
import frc.robot.commands.ScoreSpeakerKadThinksHesSmart;
import frc.robot.commands.manualControlCommands.ManualArmControl;
import frc.robot.commands.manualControlCommands.ManualClimberControl;
import frc.robot.commands.manualControlCommands.ManualShooterControl;
import frc.robot.commands.tests.PathPlannerTestCommand;
import frc.robot.subsystems.Arm;
import frc.robot.subsystems.Climber;
import frc.robot.subsystems.CommandSwerveDrivetrain;
import frc.robot.subsystems.DriveSubsystem;
import frc.robot.subsystems.LightControl;
import frc.robot.subsystems.OI;
import frc.robot.subsystems.Shooter;
import frc.robot.subsystems.SwerveModule;
import frc.robot.subsystems.SwerveModuleConfig;
import frc.robot.subsystems.vision.AprilTagSubsystem;
import frc.robot.subsystems.vision.GamePieceFinder;


public class RobotContainer {
  // The robot's subsystems are defined here...
  public static final AprilTagSubsystem m_aprilTagSubsystem = new AprilTagSubsystem();
  public static final Arm m_arm = new Arm();
  public static final Climber m_climber = new Climber();
  //public static final DriveSubsystem m_driveSubsystem = new DriveSubsystem();
  public static final GamePieceFinder m_gamePieceFinder = new GamePieceFinder();
  public static final OI m_OI = new OI();
  public static final Shooter m_shooter = new Shooter();
  public static final LightControl m_lightControl = new LightControl();

  private double MaxSpeed = TunerConstants.kSpeedAt12VoltsMps; // kSpeedAt12VoltsMps desired top speed
  private double MaxAngularRate = 4.73; //1.5 * Math.PI; // 3/4 of a rotation per second max angular velocity

  /* Setting up bindings for necessary control of the swerve drive platform */
  private final CommandXboxController joystick = new CommandXboxController(0); // My joystick
  public static final CommandSwerveDrivetrain drivetrain = TunerConstants.DriveTrain; // My drivetrain

  private final SwerveRequest.FieldCentric drive = new SwerveRequest.FieldCentric()
      .withDeadband(MaxSpeed * 0.05).withRotationalDeadband(MaxAngularRate * 0.05) // Add a 10% deadband
      .withDriveRequestType(DriveRequestType.OpenLoopVoltage); // I want field-centric
                                                               // driving in open loop
  private final SwerveRequest.SwerveDriveBrake brake = new SwerveRequest.SwerveDriveBrake();
  private final SwerveRequest.RobotCentric forwardStraight = new SwerveRequest.RobotCentric().withDriveRequestType(DriveRequestType.OpenLoopVoltage);
  private final SwerveRequest.PointWheelsAt point = new SwerveRequest.PointWheelsAt();

  /* Path follower */
  private Command runAuto = drivetrain.getAutoPath("Tests");

  private final Telemetry logger = new Telemetry(MaxSpeed);


  // Auto Chooser
  public static SendableChooser<Command> autonomousChooser = new SendableChooser<>();
  public static SendableChooser<String> m_TestChooser = new SendableChooser<>();
  public static SendableChooser<Command> pathPlannerChooser;

  /**
   * Robot container constructor
   * Set default commands, adds options to the auto chooser.
   */
  public RobotContainer() {
    NamedCommands.registerCommand("PathPlannerTestCommand", new PathPlannerTestCommand());
    NamedCommands.registerCommand("CollectFromFloor", new CollectFromFloor());
    NamedCommands.registerCommand("ScoreSpeaker", new ScoreSpeaker());
    NamedCommands.registerCommand("ScoreSpeakerAutoInitial", new ScoreSpeakerAutoInitial());
    NamedCommands.registerCommand("NoteFeedThrough", new NoteFeedThrough());
    NamedCommands.registerCommand("InitialWrist", new ControlWrist(100));
    NamedCommands.registerCommand("ScoreSpeakerKadThinksHesSmart", new ScoreSpeakerKadThinksHesSmart());

    //TODO test drive to see if this works as field centric
    //CommandScheduler.getInstance().setDefaultCommand(m_driveSubsystem, new TeleopDrive(m_driveSubsystem, m_OI));
    //CommandScheduler.getInstance().setDefaultCommand(m_climber, new ManualClimberControl(0));
 
    m_TestChooser.setDefaultOption("Competition","competition");
    m_TestChooser.addOption("TestMode", "test");

    SmartDashboard.putData("TestModeChooser",m_TestChooser);

/*
    autonomousChooser.setDefaultOption("None", null);
    autonomousChooser.addOption("Score and Move Center", new SimpleAutoCommandGroup(SimpleAutoCommandGroup.PATH_CENTER));
    autonomousChooser.addOption("Score and Move Trap Side", new SimpleAutoCommandGroup(SimpleAutoCommandGroup.PATH_TRAP_SIDE));
    autonomousChooser.addOption("Score and Move Open Side", new SimpleAutoCommandGroup(SimpleAutoCommandGroup.PATH_OPEN_SIDE));


    SmartDashboard.putData("Auto Chooser", autonomousChooser);
*/
    configureBindings();

    pathPlannerChooser = AutoBuilder.buildAutoChooser();
    SmartDashboard.putData(pathPlannerChooser);
    
    //
  }

  // Initialize Preferences For Subsystem Classes:
  public static void initPreferences() {
    System.out.println("RobotContainer: init Preferences.");
    SwerveModuleConfig.initPreferences();
    DriveSubsystem.initPreferences();
    
    OI.initPreferences();
    SwerveModule.initPreferences();
    
  }

  /*
public Command getAutonomousCommand() {
  //Set up for testing pathplanner auto
  System.out.println("Running auto");
    return autonomousChooser.getSelected();
  }
*/
  public void diagnostics() {
    boolean allGood = false;

    //String driveSubDiagnostics = m_driveSubsystem.getDiagnostics();
    String oiDiagnostics = m_OI.getDiagnostics();

    //SmartDashboard.putString("Diag/Drive Subsystem", driveSubDiagnostics);
    SmartDashboard.putString("Diag/OI", oiDiagnostics);
  }

  // called when robot initializes. Sets parking brake to false
  public void teleopInit() {
    //m_driveSubsystem.parkingBrake(false);
    // m_arm.initializeShoulder();
    
  }

  // Configures the button mappings for controllers
  private void configureBindings() {

    drivetrain.setDefaultCommand( // Drivetrain will execute this command periodically
        drivetrain.applyRequest(() -> drive.withVelocityX(-joystick.getRawAxis(1) * MaxSpeed) // Drive forward with
                                                                                           // negative Y (forward)
            .withVelocityY(-joystick.getRawAxis(0) * MaxSpeed) // Drive left with negative X (left)
            .withRotationalRate((-joystick.getRawAxis(2) * MaxAngularRate) * 2) // Drive counterclockwise with negative X (left)
        ));//.ignoringDisable(true));

    //joystick.a().whileTrue(drivetrain.applyRequest(() -> brake));
    //joystick.b().whileTrue(drivetrain
        //.applyRequest(() -> point.withModuleDirection(new Rotation2d(-joystick.getLeftY(), -joystick.getLeftX()))));

    // reset the field-centric heading on left bumper press
    joystick.button(9).onTrue(drivetrain.runOnce(() -> drivetrain.seedFieldRelative()));

    drivetrain.registerTelemetry(logger::telemeterize);

    joystick.pov(0).whileTrue(drivetrain.applyRequest(() -> forwardStraight.withVelocityX(0.5).withVelocityY(0)));
    joystick.pov(180).whileTrue(drivetrain.applyRequest(() -> forwardStraight.withVelocityX(-0.5).withVelocityY(0)));
    //joystick.pov(90).whileTrue(drivetrain.applyRequest(() ->))

      System.out.println("RobotContainer: configure Bindings");
      
      new JoystickButton(Constants.UIConstants.DRIVER_CONTROLLER, 1).toggleOnTrue(new CollectFromFloor());

      new JoystickButton(Constants.UIConstants.DRIVER_CONTROLLER, 2).toggleOnTrue(new ScoreAmp());
      new JoystickButton(Constants.UIConstants.DRIVER_CONTROLLER, 4).whileTrue(new ControlBumpererIntake(-0.75));

      new JoystickButton(Constants.UIConstants.DRIVER_CONTROLLER, 3).onTrue(new ControlClockerForTime(0.3, 0.13, 10));
      new JoystickButton(Constants.UIConstants.DRIVER_CONTROLLER, 6).whileTrue(new PassNote()); //right bumper //Previously PassNote()

      new JoystickButton(Constants.UIConstants.DRIVER_CONTROLLER, 7).whileTrue(new ScoreSpeakerKadThinksHesSmart()/*ScoreSpeaker()*/);

      new JoystickButton(Constants.UIConstants.DRIVER_CONTROLLER, 8).whileTrue(new AlignToGamePiece());
      new JoystickButton(Constants.UIConstants.DRIVER_CONTROLLER, 5).toggleOnTrue(new ScoreSpeaker()/*AlignToAprilTag()*/); //Left Bumper
      new JoystickButton(Constants.UIConstants.DRIVER_CONTROLLER, 13).whileTrue(new LowerArmFromAmp());



/*
 * 1 = underbumperintake
 * 2 = amp
 * 3 = 
 * 4 = stopunderbumper
 * 5 = shoot
 * 6 = 
 * 7 = 
 * 8 = 
 * 9 = 
 * 10 = 
 */

      //new JoystickButton(Constants.UIConstants.OPERATOR_CONTROLER, 1).whileTrue(new ManualClimberControl(0));
      new JoystickButton(Constants.UIConstants.OPERATOR_CONTROLER, 6).whileTrue(new ManualClimberControl(0));
      new JoystickButton(Constants.UIConstants.OPERATOR_CONTROLER, 6).whileTrue(new ManualArmControl());
      //new JoystickButton(Constants.UIConstants.OPERATOR_CONTROLER, 2).whileTrue(new ControlArm(700));
      new JoystickButton(Constants.UIConstants.OPERATOR_CONTROLER, 5).whileTrue(new ResetClimber());

      new JoystickButton(Constants.UIConstants.OPERATOR_CONTROLER, 4).onTrue(new Climb_Prep());
      //new JoystickButton(Constants.UIConstants.OPERATOR_CONTROLER, 1).onTrue(new Climb_Hang());
      new JoystickButton(Constants.UIConstants.OPERATOR_CONTROLER, 3).whileTrue(new ClimberServoControlManual());
      new JoystickButton(Constants.UIConstants.OPERATOR_CONTROLER, 1).whileTrue(new ResetWristZero());

      

      // Servo Test
      //new JoystickButton(Constants.UIConstants.DRIVER_CONTROLLER, 1).whileTrue(new ControlClimber(0));

    }

    public Command getAutonomousCommand(){
      return pathPlannerChooser.getSelected();
    }
}