// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot;

import java.util.Optional;

import com.pathplanner.lib.auto.AutoBuilder;
import com.pathplanner.lib.auto.NamedCommands;
import com.pathplanner.lib.commands.PathPlannerAuto;

import edu.wpi.first.math.geometry.Pose2d;
import edu.wpi.first.math.geometry.Rotation2d;
import edu.wpi.first.wpilibj.DataLogManager;
import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.TimedRobot;
import edu.wpi.first.wpilibj.DriverStation.Alliance;
import edu.wpi.first.wpilibj.smartdashboard.SendableChooser;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.Command;
import edu.wpi.first.wpilibj2.command.CommandScheduler;
import frc.robot.commands.*;

import frc.robot.commands.manualControlCommands.ManualArmControl;
import frc.robot.commands.manualControlCommands.ManualClimberControl;
import frc.robot.commands.manualControlCommands.ManualShooterControl;
import frc.robot.commands.manualControlCommands.ManualWristControl;
import frc.robot.commands.tests.PathPlannerTestCommand;
import frc.robot.subsystems.CommandSwerveDrivetrain;

public class Robot extends TimedRobot {
  private Command m_autonomousCommand;
  private SendableChooser<Command> autonomousChooser = new SendableChooser<>();
  private SendableChooser<PathPlannerAuto> pPlannerChooser = new SendableChooser<>();

  private RobotContainer m_robotContainer;
  private int diagnosticCounter = 0;
  Optional<Alliance> ally;

  @Override
  public void robotInit() {
    RobotContainer.m_climber.servoControl(60);
    SmartDashboard.putNumber("IsetTheWristPOS", 0);
    // We must call this before creating the robot container: Sets up preferences *once* at startup.
    SmartDashboard.putBoolean("SwapIntakeControl", false);
    autonomousChooser.setDefaultOption("None", null);
    /*autonomousChooser.addOption("Score and Move Center", new SimpleAutoCommandGroup(SimpleAutoCommandGroup.PATH_CENTER));
    autonomousChooser.addOption("Score and Move Trap Side", new SimpleAutoCommandGroup(SimpleAutoCommandGroup.PATH_TRAP_SIDE));
    autonomousChooser.addOption("Score and Move Open Side", new SimpleAutoCommandGroup(SimpleAutoCommandGroup.PATH_OPEN_SIDE));*/

    SmartDashboard.putData("Auto Chooser", autonomousChooser);

    // Create robot container
    m_robotContainer = new RobotContainer();
    RobotContainer.m_shooter.zeroEncoder();
    RobotContainer.m_arm.zeroEncoder();
    //RobotContainer.m_driveSubsystem.zeroHeading();
    
    Rotation2d zeroRotate = new Rotation2d();
    Pose2d zero = new Pose2d(0.0, 0.0, zeroRotate);
    final CommandSwerveDrivetrain drivetrain = TunerConstants.DriveTrain;
    drivetrain.runOnce(() -> drivetrain.seedFieldRelative());
    //RobotContainer.m_lightControl.setBlinkinColor(-0.21);
    //DataLogManager.start();
  }

  @Override
  public void robotPeriodic() {
    CommandScheduler.getInstance().run();
  }

  @Override
  public void disabledInit() {}

  @Override
  public void disabledPeriodic() {
    if(diagnosticCounter > 100){
      m_robotContainer.diagnostics();
      diagnosticCounter = 0;
    }
    else{
      diagnosticCounter++;
    }
  }

  @Override
  public void disabledExit() {}

  @Override
  public void autonomousInit() {
    try {
    ally = DriverStation.getAlliance();

    SmartDashboard.putString("AllianceCollor", DriverStation.getAlliance().toString());
    // Alliance color lighting
    if (ally.get() == Alliance.Blue) {
                SmartDashboard.putNumber("AllianceCollorNumber", 0.86);
      RobotContainer.m_lightControl.setBlinkinColor(0.86);
      //RobotContainer.LedSubsystem.ledMode(0.87);

      SmartDashboard.putNumber("AprilTagWeWant", 7);
      
    } else{
    if (ally.get() == Alliance.Red) {
          //RobotContainer.LedSubsystem.ledMode(0.61);
          SmartDashboard.putNumber("AllianceCollorNumber", 0.6);
          RobotContainer.m_lightControl.setBlinkinColor(0.6);
          SmartDashboard.putNumber("AprilTagWeWant", 4);

      }
    }
      
    } catch (Exception e) {
      // TODO: handle exception
    }
    
    System.out.println("Robot: Autonomous Init");
    SmartDashboard.putBoolean("TestCommand", false);
    //m_autonomousCommand = m_robotContainer.getAutonomousCommand();

    m_autonomousCommand = m_robotContainer.getAutonomousCommand();

    if (m_autonomousCommand != null) {
      m_autonomousCommand.schedule();
    } else {
      System.out.println("NO Autonomous Command!");
    }
    //new SimpleAuto().schedule();

  }

  @Override
  public void autonomousPeriodic() {
    
  }

  @Override
  public void autonomousExit() {}

  @Override
  public void teleopInit() {
    System.out.println("Robot: Teleop Init");
    if (m_autonomousCommand != null) {
      m_autonomousCommand.cancel();
    }
    if(m_robotContainer.m_TestChooser.getSelected() == "test"){
      SmartDashboard.putData("ArmControl", new ManualArmControl());
      SmartDashboard.putData("ShooterControl", new ManualShooterControl(0,0));
      SmartDashboard.putData("WristControl",new ManualWristControl(0));
      

    }
    SmartDashboard.putData("ServoRelease",new ClimberServoControl(100));
    SmartDashboard.putData("ServoLock",new ClimberServoControl(60));

    SmartDashboard.putData("BreakMode-Off",new BreakMode(false));
    SmartDashboard.putData("BreakMode-On",new BreakMode(true));
    SmartDashboard.putData("ZeroArmAndWristEncoder",new ZeroArmAndWristEncoder());

    SmartDashboard.putData("ManualClimber",new ManualClimberControl(0));
    SmartDashboard.putData("ZeroClimberEncoder",new ZeroClimberEncoder());
    m_robotContainer.teleopInit();

    try {
    ally = DriverStation.getAlliance();

    //RobotContainer.m_driveSubsystem.resetPose(zero);
    SmartDashboard.putString("AllianceCollor", DriverStation.getAlliance().toString());
    // Alliance color lighting
    if (ally.get() == Alliance.Blue) {
      //RobotContainer.m_OI.setBlinkinColor(0.86);
      //RobotContainer.LedSubsystem.ledMode(0.87);

      SmartDashboard.putNumber("AprilTagWeWant", 7);
      
    } else{
    if (ally.get() == Alliance.Red) {
          //RobotContainer.LedSubsystem.ledMode(0.61);
         // RobotContainer.m_OI.setBlinkinColor(0.6);
          SmartDashboard.putNumber("AprilTagWeWant", 4);

      }
    }
      
    } catch (Exception e) {
      // TODO: handle exception
    }
    
  }

  @Override
  public void teleopPeriodic() {
    RobotContainer.m_shooter.printShooterData();
    RobotContainer.m_arm.printArmData();
    RobotContainer.m_climber.printClimberEncoders();
    //RobotContainer.m_OI.setBlinkinColor(RobotContainer.m_OI.getOperatorAxis3());
    //SmartDashboard.putNumber("ThrottleLights", RobotContainer.m_OI.getOperatorAxis3());
    
  }

  @Override
  public void teleopExit() {}

  @Override
  public void testInit() {
    System.out.println("Robot: testInit");
  }

  @Override
  public void testPeriodic() {}

  @Override
  public void testExit() {}
}
