
package frc.robot;

import com.pathplanner.lib.util.HolonomicPathFollowerConfig;
import com.pathplanner.lib.util.PIDConstants;
import com.pathplanner.lib.util.ReplanningConfig;

import edu.wpi.first.math.geometry.Rotation3d;
import edu.wpi.first.math.geometry.Transform3d;
import edu.wpi.first.math.geometry.Translation2d;
import edu.wpi.first.math.geometry.Translation3d;
import edu.wpi.first.math.kinematics.SwerveDriveKinematics;
import edu.wpi.first.math.util.Units;
import edu.wpi.first.wpilibj.Joystick;
import edu.wpi.first.wpilibj.XboxController;

public class Constants {
    
    public static class DrivetrainConstants {

        public static final String DRIVE_TRAIN_CAN_BUS_NAME = "Blue";
        public static final int FRONT_LEFT_CAN_ID = 11;
        public static final int FRONT_LEFT_STEER_ID = 7;
        public static final int FRONT_LEFT_ENCODER_ID = 3;

        public static final int FRONT_RIGHT_CAN_ID = 12;
        public static final int FRONT_RIGHT_STEER_ID = 8;
        public static final int FRONT_RIGHT_ENCODER_ID = 4;

        public static final int BACK_LEFT_CAN_ID = 13;
        public static final int BACK_LEFT_STEER_ID = 9;
        public static final int BACK_LEFT_ENCODEr_ID = 5;

        public static final int BACK_RIGHT_CAN_ID = 14;
        public static final int BACK_RIGHT_STEER_ID = 10;
        public static final int BACK_RIGHT_ENCODER_ID = 6;


        
        public static final double STEER_ANGLE_OFFSET_MOD_FL = 1.01702926236818;//-1.018563243156066;
        public static final double STEER_ANGLE_OFFSET_MOD_FR = 2.090815813888129;//-2.144505141464126;
        public static final double STEER_ANGLE_OFFSET_MOD_BL = -1.553922538128155;//1.633689539098208;
        public static final double STEER_ANGLE_OFFSET_MOD_BR = 2.439029452738169;//3.844155854441417;

        // Chassis configuration
        public static final double kTrackWidth = Units.inchesToMeters(24);
        // Distance between centers of right and left wheels on robot
        public static final double kWheelBase = Units.inchesToMeters(24);
        // Distance between front and back wheels on robot
        public static final SwerveDriveKinematics kDriveKinematics = new SwerveDriveKinematics(
            new Translation2d(-kWheelBase / 2, kTrackWidth / 2),
            new Translation2d(kWheelBase / 2, -kTrackWidth / 2),
            new Translation2d(-kWheelBase / 2, kTrackWidth / 2),
            new Translation2d(-kWheelBase / 2, -kTrackWidth / 2));
        /*
         
        public static final double STEER_ANGLE_OFFSET_MOD_FL = 2.879;
        public static final double STEER_ANGLE_OFFSET_MOD_FR = 1.866;
        public static final double STEER_ANGLE_OFFSET_MOD_BL = 2.422;
        public static final double STEER_ANGLE_OFFSET_MOD_BR = 1.109;
         */

        public static final double MAX_LINEAR_SPEED = 5;
        public static final double MAX_LINEAR_SPEED_PREF = 2.0;

        public static final double MODULE_POSITIONS = 0.5017;

    }
    public static final double maxModuleSpeed = 0.2; // M/S was 4.5
    
    public static final Translation2d flModuleOffset = new Translation2d(0.4, 0.4);
    public static final Translation2d frModuleOffset = new Translation2d(0.4, -0.4);
    public static final Translation2d blModuleOffset = new Translation2d(-0.4, 0.4);
    public static final Translation2d brModuleOffset = new Translation2d(-0.4, -0.4);

    
    public static final HolonomicPathFollowerConfig pathFollowerConfig = new HolonomicPathFollowerConfig(
      new PIDConstants(5.0, 0, 0), // Translation constants was 5
      new PIDConstants(7.0, 0, 0), // Rotation constants was 5
      maxModuleSpeed, 
      flModuleOffset.getNorm(), // Drive base radius (distance from center to furthest module) 
      new ReplanningConfig()
    );

    public static class UIConstants {
        public static final XboxController DRIVER_CONTROLLER = new XboxController(0);
        public static final Joystick OPERATOR_CONTROLER = new Joystick(1);
        //public static final Joystick DRIVER_LOGITECH_JOYSTICK = new Joystick(port:2);
        public static final Joystick SWITCH_CONTROLLER = new Joystick(0);
        public static final int VISION_TEST_BUTTON = 2; // B
        
        public static final int INTAKE_BTN = 5;
        public static final int SHOOT_BTN = 6;
        public static final int RESET_POSE_BTN = 11;
        public static final int ARM_DOWN = 7;
        public static final int ARM_UP = 8;
        public static final int WRIST_COLLECT = 9;
        public static final int WRIST_STORE = 10;


        public static final int ALIGN_TO_TAG_BUTTON = 3;
        public static final int SHOOT_BUTTON = 4;
        public static final int INTAKE_BUTTON = 1;
        /*
         * Menu = 8
         * X = 3
         * A = 1
         * Y = 4
         * B = 2 
         */

    }

    public static class VisionConstants {
        public static final String APRIL_TAG_FAMILY = "36H11";
        public static final String APRILTAG_CAMERA_NT_ID = "limelight-front";
        public static final String GAMEPIECE_CAMERA_NT_ID = "limelight-gpiece";
        public static final Transform3d FRONT_CAMERA_TRANSFORM = 
                new Transform3d(new Translation3d(0.2159, 0.1397, 0.508), new Rotation3d(0, 0.2617, 0));
    }
    public static class ArmConstants {
        public static final int PEAK_VELOCITY_UP = 13360;
        public static final float PERCENT_OF_PEAK_UP = .50f;
        public static final float CRUISE_VELOCITY_ACCEL_UP = PEAK_VELOCITY_UP * PERCENT_OF_PEAK_UP; // 8,684
        //MOTOR IDS
        public static final int ARM_MOTOR_CAN_ID = 17;
        public static final int ARM_ENCODER_CAN_ID = 16; 
    }

    public static class BumperIntake{
        public static final int BUMBERINTAKE_MOTOR_ID = 25;
    }

    public static class ShooterConstants {
        //MOTOR IDS
        public static final int SHOOTER_MOTOR_CAN_ID = 18;
        public static final int CLOCKER_MOTOR_CAN_ID = 19;
        public static final int SHOOTER_WRIST_CAN_ID = 20;
        public static final int SHOOTER_WRIST_ENCODER_CAN_ID = 21;
        public static final int BASE_WRIST_POS = 1603;
        public static final int FOLDED_WRIST_POS = 200;
        public static final int SPEAKER_VELOCITY = -16000;

    }

    public static class ClimberConstants{
        public static final int CLIMBER_1_CAN_ID = 22;
        public static final int CLIMBER_2_CAN_ID = 23;
        public static final int CLIMBER_WHEELS_CAN_ID = 24;
        public static final int CLIMBER_RELEASE_SERVO_PWM_ID = 2;
        public static final double CLIMBER_RELEASE_SERVO_OPEN_VALUE = .5;


    }
}