// RobotBuilder Version: 4.0
//
// This file was generated by RobotBuilder. It contains sections of
// code that are automatically generated and assigned by robotbuilder.
// These sections will be updated in the future when you export to
// Java from RobotBuilder. Do not put any code or make any change in
// the blocks indicating autogenerated code or it will be lost on an
// update. Deleting the comments indicating the section will prevent
// it from being updated in the future.

// ROBOTBUILDER TYPE: Subsystem.

package frc.robot.subsystems;

import frc.robot.Constants;
import frc.robot.RobotContainer;
import edu.wpi.first.wpilibj.Servo;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.SubsystemBase;

import com.ctre.phoenix.motorcontrol.ControlMode;
import com.ctre.phoenix.motorcontrol.NeutralMode;
import com.ctre.phoenix.motorcontrol.can.WPI_TalonFX;

/**
 *
 */
public class Shooter extends SubsystemBase {
    private WPI_TalonFX clocker;
    private WPI_TalonFX leftShooter;
    private WPI_TalonFX rightShooter;
    private Servo hoodL;
    private Servo hoodR;
    private double shooterAngle;

    /**
    *
    */
    public Shooter() {
        clocker = new WPI_TalonFX(Constants.ShooterConstants.Clocker);
        leftShooter = new WPI_TalonFX(Constants.ShooterConstants.shootLeft);
        rightShooter = new WPI_TalonFX(Constants.ShooterConstants.shootRight);
        hoodL = new Servo(Constants.ShooterConstants.hoodL);
        hoodR = new Servo(Constants.ShooterConstants.hoodR);

        clocker.configFactoryDefault();
        clocker.setNeutralMode(NeutralMode.Brake);
        leftShooter.configFactoryDefault();
        rightShooter.configFactoryDefault();
        leftShooter.setNeutralMode(NeutralMode.Coast);
        rightShooter.setNeutralMode(NeutralMode.Coast);

        /**
         * P = Increase until oscillations occur
         * I = If the postion canot quite reach the end goal increase I 
         * D = Smoothing/slowing the acceleration of the movement. Use 10x at least to 100x
         * F = Feed forward norminal power required to move
         */
        leftShooter.config_kP(0, 0.2);
        leftShooter.config_kI(0, 0.0);
        leftShooter.config_kD(0, 0.2);
        leftShooter.config_kF(0, 0.069);

        rightShooter.config_kP(0, 0.2);
        rightShooter.config_kI(0, 0.0);
        rightShooter.config_kD(0, 0.2);
        rightShooter.config_kF(0, 0.069);
    }

    /**
     * For TargetOffset angle
     */
    static double targetOffsetAngle_Vertical = 0;
    /**
    top velocity 16500
    */
    public void spinUp(double velocity) {
        leftShooter.set(ControlMode.Velocity, velocity);
        rightShooter.set(ControlMode.Velocity, -velocity);
        SmartDashboard.putNumber("Shooter Velocity", leftShooter.getSelectedSensorVelocity());
    }

    public void hoodMove(double posistion) {
        //hoodL.set(posistion);
        //hoodR.set(posistion);
        //System.out.println(hoodL.get());

    }

    public void hoodMoveDegrees(double degrees) {
        hoodL.setAngle(degrees);
        hoodR.setAngle(degrees);
        //System.out.println(hoodL.get());
    }

    public void testSpinUp(double speed) {
        leftShooter.set(ControlMode.PercentOutput,-speed);
        rightShooter.set(ControlMode.PercentOutput,speed);
        
        SmartDashboard.putNumber("--- SHOOTER SPEED", speed);
        SmartDashboard.putNumber("Shooter velocity", leftShooter.getSelectedSensorVelocity());
    }


    public void stopSpinUp() {
        leftShooter.set(ControlMode.PercentOutput, 0);
        rightShooter.set(ControlMode.PercentOutput, 0);
    }

    /**
     * Formerly autoAim
     * Used for finding range and angle for the shooter hood
     * 
     */
    public void autoHood(){
        
        // CALCULATING THE LINEAR ACUATOR POSISTION FROM THE ANGLE OF THE SHOOTER FROM DISTANCE
        //calculate distance
        double distanceFromLimelightToGoalInches = getGoalDistance();
        double angleOfdesentRads = Math.toRadians(Constants.ShooterConstants.angleOfdesent);

        //calculate angle from distance
        double shooterAngle = Math.toDegrees(
            Math.atan((Math.tan(angleOfdesentRads)*distanceFromLimelightToGoalInches-(2*Constants.ShooterConstants.goalHigh_ShooterDelta)) /-distanceFromLimelightToGoalInches));

        this.shooterAngle = shooterAngle;

        //find linear acuator from angle
        SmartDashboard.putNumber("shooter angle", shooterAngle);
        SmartDashboard.putNumber("distance from goal", distanceFromLimelightToGoalInches);

        SmartDashboard.putNumber("Math.cos(shooterAngle)", Math.cos(shooterAngle));
        
        double totalActuatorLength = Math.sqrt(Math.pow(10.35, 2) + Math.pow(11.79, 2) - 2*10.35*11.79*Math.cos(shooterAngle));
        SmartDashboard.putNumber("totalAcuatorLength", totalActuatorLength);
        double actuateDistance = (totalActuatorLength - 6.41 ) /4.13 ;
        //SmartDashboard.putNumber("acuator posistion", actuateDistance);
        System.out.println("actuator pos" + actuateDistance);
        Double test = Double.valueOf(actuateDistance);
        //RobotContainer.m_DriveSubsystem.TowerTrack();

        actuateDistance = (actuateDistance * -1) + 1;

        if(test.isNaN()){

        } else {
        hoodL.set(actuateDistance);
        hoodR.set(actuateDistance);
        }
        
    }

    public double getShooterAngle() {
        return this.shooterAngle;
    }

    /**
     * Calculates shooter motor speed needed to hit target at given angle
     * 
     * @param hoodAngleInRadians
     */
    public void autoVelocity(double hoodAngleInRadians, double distance)
    {
        
        // this calculation of velocity is not needs to be verified then applied to shooter wheels
        /*
        double angleTan = Math.tan(hoodAngleInRadians);
        double velocity = 
                Math.sqrt( -(
                    9.8 * (distance*distance) * (1 + (angleTan * angleTan))
                    / 
                    ((2*Constants.ShooterConstants.goalHigh_ShooterDelta) - (2*distance * angleTan))
                    ));
        */
        SmartDashboard.putNumber("Throttle", (((RobotContainer.m_oi.getOpThrottle() * -1) + 1) / 2 * -1));
        testSpinUp((((RobotContainer.m_oi.getOpThrottle() * -1) + 1) / 2 * -1));
    }

    public double getGoalDistance() {
        
        double ty = RobotContainer.m_Limelight.getuplimeY();
       
        if(ty > 0.3){
            targetOffsetAngle_Vertical = ty;
        }
    
        double angleToGoalDegrees = Constants.ShooterConstants.limelightMountAngleDegrees + targetOffsetAngle_Vertical;
        double distanceFromLimelightToGoalInches = 
        (Constants.ShooterConstants.goalHighHeightInches - Constants.ShooterConstants.limelightLensHeightInches)/Math.tan(Math.toRadians(angleToGoalDegrees));

        return distanceFromLimelightToGoalInches;
    }

    public double getVelocity() {
        double lvelocity = leftShooter.getSelectedSensorVelocity();
        double rvelocity = rightShooter.getSelectedSensorVelocity();

        if(lvelocity < rvelocity) {
            return rvelocity;
        } else {
            return lvelocity;
        }
    }

   public void autoHighGoalMove(){

   }

   public void fieldGoal(){
        testSpinUp(-1);
        double totalActuatorLength = Math.sqrt(Math.pow(10.35, 2) + Math.pow(11.79, 2) - 2*10.35*11.79*Math.cos(45));
        hoodR.set(totalActuatorLength);
   }


    @Override
    public void periodic() {
        // This method will be called once per scheduler run
    }

    @Override
    public void simulationPeriodic() {
        // This method will be called once per scheduler run when in simulation
    }

    // Put methods for controlling this subsystem
    // here. Call these from Commands.

}